/****************************************************************************/
/* TINTEDZN                                                                 */
/*--------------------------------------------------------------------------*/
/* Objet TIntegerEditZone (Zone d'dition d'un nombre entier)               */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 10/01/95                                                    */
/****************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "Vocab.h"

#include "Settings.h"

#include "Strings.h"

#include "TIntEdZn.h"

/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************/
/* Constructeur */
/* ------------ */
/****************************************************************************/
/* parent           : Objet auquel appartient l'objet                       */
/* rel_x,rel_y      : Coordonnes de la zone d'dition p/r au groupe        */
/* xoffset_caption,                                                         */
/* yoffset_caption  : Coordonnes du titre p/r au contenu de la zone d'dit.*/
/* caption          : Titre de la zone d'dition (hot-key prcd de ~)     */
/* display_length   : Longueur visible du contenu de la zone d'dition      */
/* max_length       : Longueur maximale du contenu de la zone d'dition     */
/* min_value,                                                               */
/* max_value        : Valeurs minimale et maximale pouvant tre saisies     */
/* string           : Contenu initial de la zone d'dition                  */
/* enabled          : ENABLED si la zone est activable (DISABLED sinon)     */
/****************************************************************************/

TIntegerEditZone::TIntegerEditZone(PObject parent,
		                   int rel_x,int rel_y,
		                   int xoffset_caption,int yoffset_caption,
                                   const char *caption,
                                   int display_length,
		                   int max_length,
                                   long min_value,long max_value,
		                   const char *string,
				   bool enabled)
                 :TEditZone(parent,
		            rel_x,rel_y,
                            xoffset_caption,yoffset_caption,
		            caption,
                            display_length,
		            max_length,
		            string,
                            enabled)
{
  // Valeurs min et max
  // Corrige la chane si elle est invalide
  // (le constructeur de TEditZone n'ayant pas appel la bonne fonction
  // m_valid_string, et parce que la valeur peut tre hors limites)

  m_set_min_max_values(min_value,max_value);
}

/***************/
/* Destructeur */
/* ----------- */
/***************/

TIntegerEditZone::~TIntegerEditZone()
{
}

/****************************************************************************/
/* m_set_min_max_values                                                     */
/*--------------------------------------------------------------------------*/
/* Modifie les valeurs min et max de la zone de saisie                      */
/****************************************************************************/

void TIntegerEditZone::m_set_min_max_values(long min_value,long max_value)
{
  char string[LONG_MAX_LENGTH];

  long value;
  bool invalid;

  if (max_value<min_value)
    max_value=min_value;

  f_min_value=min_value;
  f_max_value=max_value;

  // Correction de la chane par dfaut

  invalid=true;
  if (StringToLong(f_default_string,value))
    if ((value>=min_value) && (value<=max_value))
      invalid=false;

  if (invalid)
    {
      value=min_value;
      LongToString(value,string);
      delete []f_default_string;
      f_default_string=new char [strlen(string)+1];
      strcpy(f_default_string,string);
    }

  m_set_string(m_get_string());
}


/*****************************************************/
/* m_string_valid : Indique si une chane est valide */
/* --------------   pour ce type de zone de saisie   */
/*****************************************************/

bool TIntegerEditZone::m_string_valid(const char *string)
{
  long value;

  int string_length=strlen(string);

  if (string_length==0)
    return false;

  // Chane trop longue

  if (string_length>f_max_length)
    return false;

  // C'est une chane valide pour un entier long

  if (!StringToLong(string,value))
    return false;

  // Valeur dans les limites autorises

  if ((value<f_min_value) || (value>f_max_value))
    return false;

  return true;
}

/*ͻ*/
/*                            METHODES PRIVEES                            */
/*ͼ*/

/**************************************************************/
/* m_valid_character : Indique si un caractre est acceptable */
/* -----------------   par ce type de zone de saisie          */
/**************************************************************/

bool TIntegerEditZone::m_character_valid(int character)
{
  if (   ((character>='0')&&(character<='9'))
      || (character=='-')
      || (character=='+')
      || (character==' '))
    return true;

  return false;
}

/****************************************************************************/
/* m_get_error_message                                                      */
/*--------------------------------------------------------------------------*/
/* Retourne un message indiquant pourquoi la chaine n'est pas valide        */
/****************************************************************************/

const char *TIntegerEditZone::m_get_error_message()
{
  const char *msg = GetString(VOC_MUST_BE_INTEGER_BETWEEN);

  if (f_error_message!=NULL)
    delete []f_error_message;

  f_error_message=new char [strlen(msg)+LONG_MAX_LENGTH+LONG_MAX_LENGTH-6+1];
  sprintf(f_error_message,msg,f_min_value,f_max_value);

  return(f_error_message);
}

