/****************************************************************************/
/* TGROUP                                                                   */
/*--------------------------------------------------------------------------*/
/* Objet TGroup (Type gnrique d'objet comprenant d'autres objets dont un  */
/*               seul  la fois a le focus)                                 */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 10/01/95                                                    */
/****************************************************************************/

#include <stdlib.h>
#include <values.h>

#include "Const.h"
#include "JPDebug.h"

#include "JPAppli.h"

#include "Errors.h"
#include "Mouse.h"

#include "TObject.h"
#include "TWindow.h"
#include "TGroup.h"


/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************/
/* Constructeur */
/* ------------ */
/****************************************************************************/
/* parent           : Objet auquel appartient l'objet                       */
/* type             : Type du groupe                                        */
/* rel_x,rel_y      : Coordonnes du groupe p/r  son groupe                */
/* width,height     : Dimensions du groupe                                  */
/* caption          : Lgende du groupe (hot-key prcd de ~)              */
/* enabled          : ENABLED si le groupe est activable (DISABLED sinon)   */
/* focus_depending_                                                         */
/*   aspect         : Indique si l'aspect du groupe varie quand il prend ou */
/*                    perd le focus                                         */
/* can_be_enabled   : Indique si l'objet peut devenir activable             */
/****************************************************************************/

TGroup::TGroup(PObject parent,
	       int type,
	       int rel_x,int rel_y,
	       int width,int height,
	       unsigned background,
               const char *caption,
	       bool enabled,
	       bool focus_depending_aspect,
               bool can_be_enabled,
               bool need_focused_element)
       :TObject(parent,
		type,
		rel_x,rel_y,
		width,height,
                background,
		caption,
		enabled,
		focus_depending_aspect,
                can_be_enabled,
		false)  // NOT_SIMPLE

{
  // Objet de la liste qui a le focus

  f_focused_element=NULL;

  // Indique si le groupe peut n'avoir aucun lment
  // avec le focus quand lui l'a

  f_need_focused_element=need_focused_element;

}

/***************/
/* Destructeur */
/* ----------- */
/***************/

TGroup::~TGroup()
{
}


/****************************************************************************/
/* m_get_focused_element                                                     */
/*--------------------------------------------------------------------------*/
/* Retourne un pointeur sur l'objet du groupe qui a le focus (NULL)         */
/****************************************************************************/

PObject TGroup::m_get_focused_element()
{
  return((f_focused_element==NULL)?NULL:(f_focused_element->object));
}

/****************************************************************************/
/* m_can_lose_focus                                                         */
/*--------------------------------------------------------------------------*/
/* Indique si l'objet peut prendre le focus                                 */
/****************************************************************************/

bool TGroup::m_can_lose_focus()
{
  if (!f_focused)
    return true;

  if (f_focused_element!=NULL)
    {
      return(f_focused_element->object->m_can_lose_focus());
    }

  return true;
}


/********************************************************************/
/* m_set_focus : Donne le focus au groupe.                          */
/* -----------   Si un lment doit prendre le focus, le groupe     */
/*               le donne lui-mme au premier objet                 */
/*               possible qu'il contient.                           */
/*               Retourne true en cas de russite                   */
/********************************************************************/

bool TGroup::m_set_focus()
{
  PObjectNode node;
  PObject object;
  bool found;

  if (!f_enabled)
    return false;

  if (!f_need_focused_element)
    {
      if (f_focused)
        {
          if (f_focused_element!=NULL)
            {
              object=f_focused_element->object;
              if (!object->m_can_lose_focus())
                return false;
              object->m_lose_focus();
              f_focused_element=NULL;
	      if ((f_focus_depending_aspect) && (f_window->m_is_active()))
		m_display_focus_depending_part();
            }
        }
      else
        {
          if (f_parent!=NULL)
            return (f_parent->m_set_focus_to_element(f_number));
	  m_take_focus();
        }

      return true;
    }

  // Sinon

  node=f_element_list;
  found=false;

  while ((node!=NULL) && (!found))
    {
      if (node->object->m_set_focus())
	found=true;
      else
	node=node->next;
    }

  return(f_focused);
}

/***********************************************************************/
/* m_set_focus_to_last_element : Donne le focus au groupe.              */
/* --------------------------   Le groupe donne lui-mme le focus au   */
/*                              dernier objet possible qu'il contient. */
/*                              Retourne true en cas de russite       */
/***********************************************************************/

bool TGroup::m_set_focus_to_last_element()
{
  PObjectNode node;
  bool found;

  if (!f_enabled)
    return false;

  node=f_last_element;
  found=false;

  while ((node!=NULL) && (!found))
    {
      if (node->object->m_set_focus_to_last_element())
	found=true;
      else
	node=node->last;
    }

  if (!found)
    {
      if (!f_need_focused_element)
        {
          if (f_parent!=NULL)
            return (f_parent->m_set_focus_to_element(f_number));
	  m_take_focus();
        }
    }

  return(f_focused);
}

/****************************************************************************/
/* m_get_focused_object                                                     */
/*--------------------------------------------------------------------------*/
/* Retourne l'objet du groupe qui a le focus                                */
/****************************************************************************/

PObject TGroup::m_get_focused_object()
{
  if (!f_focused)
    return(NULL);

  if (f_focused_element==NULL)
    return(this);

  return(f_focused_element->object->m_get_focused_object());
}


/*ͻ*/
/*                           METHODES PROTEGEES                           */
/*ͼ*/


/****************************************/
/* m_del_element : Supprime un lment  */
/* -------------   de l'objet           */
/****************************************/

void TGroup::m_del_element(int object_number)
{
  PObjectNode node;

  node=m_object_number_to_element_node(object_number);

  // Si l'lment supprim a le focus

  if (f_focused_element==node)
    f_focused_element=NULL;

  TObject::m_del_element(object_number);
};

/***************************************************************/
/* m_set_focus_to_element : Attribution du focus  un objet  */
/* ----------------------   Retourne true si russite.       */
/***************************************************************/

bool TGroup::m_set_focus_to_element(int object_number)
{
  PObject element;

  if (f_focused_element!=NULL)
    {
      element=f_focused_element->object;
      if (element->f_number==object_number)
	return true;

      if (!element->m_can_lose_focus())
	return false;

    }

  // Si le groupe dont l'objet prend le focus n'a pas le focus

  if (!f_focused)
    {
      if (f_parent!=NULL)
	{
	  if (!f_parent->m_set_focus_to_element(f_number))
	    return false;
	}
      else
	m_take_focus();
    }


  if (f_focused_element!=NULL)
    {
      f_focused_element->object->m_lose_focus();
      f_focused_element=NULL;
    }

  f_focused_element=m_object_number_to_element_node(object_number);
  element=f_focused_element->object;

  JPDEBUG_TEST(DEBUG_ERROR_6,element->m_is_enabled());

  element->m_take_focus();

  if ((!f_need_focused_element) && (f_focus_depending_aspect)
       && (f_window->m_is_active()))
    m_display_focus_depending_part();

  return true;
}

/****************************************/
/* m_lose_focus : Appele quand le      */
/* ------------   groupe perd le focus  */
/****************************************/

void TGroup::m_lose_focus()
{
  if (f_focused)
    {
      if (f_focused_element!=NULL)
	{
	  f_focused_element->object->m_lose_focus();
	  f_focused_element=NULL;
	}
      else
	m_set_previous_focused_object();

      f_focused=false;

      if ((f_focus_depending_aspect) && (f_window->m_is_active()))
		m_display_focus_depending_part();

		focusLostAction_();
    }
}


/****************************************/
/* m_take_focus : Appele quand le      */
/* ------------   groupe prend le focus */
/****************************************/

void TGroup::m_take_focus()
{
  if ((!f_focused) && (f_enabled))
    {
      f_focused=true;
      if ((f_focus_depending_aspect) && (f_window->m_is_active()))
		m_display_focus_depending_part();

		focusTakenAction_();
    }

}


/*********************************************************************/
/* m_left_button_pressed_event : L'utilisateur a cliqu dans l'objet */
/* ---------------------------   avec le bouton gauche               */
/*                               (l'objet tant activable).          */
/*                               Retourne true si l'objet est        */
/*                               intress par cet vnement.        */
/*********************************************************************/

bool TGroup::m_left_button_pressed_event(int x,int y)
{
  int  x1_element,y1_element;
  int  x2_element,y2_element;

  int  x1=m_get_x();
  int  y1=m_get_y();

  PObject element;
  bool event=false;

  PObjectNode node;


  // On regarde si on a cliqu dans l'objet qui a dj le focus
  // et qui ncessairement, est activable

  if  (f_focused_element!=NULL)
    {
      element=f_focused_element->object;

      x1_element=x1         + element->f_rel_x;
      x2_element=x1_element + element->f_width-1;
      y1_element=y1         + element->f_rel_y;
      y2_element=y1_element + element->f_height-1;


      if (   (x >= x1_element)
	  && (x <= x2_element)
	  && (y >= y1_element)
	  && (y <= y2_element)
	 )
	if (element->m_left_button_pressed_event(x,y))
	  event=true;
    }

  // Sinon, clic sur un autre objet que celui qui a le focus

  node=f_element_list;

  while ((node!=NULL) && (!event))
    {
      if (f_focused_element!=node)
	{
	  element=node->object;
	  x1_element=x1         + element->f_rel_x;
	  x2_element=x1_element + element->f_width-1;
	  y1_element=y1         + element->f_rel_y;
	  y2_element=y1_element + element->f_height-1;

	  if (element->f_enabled)
	    {
	      if (   (x >= x1_element)
		  && (x <= x2_element)
		  && (y >= y1_element)
		  && (y <= y2_element)
		 )
		event=element->m_left_button_pressed_event(x,y);
	    }
	}
      node=node->next;
    }

  return(event);
}

/**************************************************************************/
/* m_left_button_double_click_event : L'utilisateur a double-cliqu dans  */
/* --------------------------------   l'objet avec le bouton gauche       */
/*                                    (l'objet tant activable et         */
/*                                    ayant dj subi l'vnement         */
/*                                    m_left_button_pressed_event)        */
/*                                    Retourne true si l'objet est        */
/*                                    intress par cet vnement.        */
/**************************************************************************/

bool TGroup::m_left_button_double_click_event(int x,int y)
{
  PObject element;
  bool event=false;
  PObjectNode node;

  int  x1_element,y1_element;
  int  x2_element,y2_element;

  int  x1=m_get_x();
  int  y1=m_get_y();

  // On regarde si on a double_cliqu dans l'objet qui a dj le focus

  if (f_focused_element!=NULL)
    {
      element=f_focused_element->object;
      x1_element=x1        + element->f_rel_x;
      x2_element=x1_element + element->f_width-1;
      y1_element=y1        + element->f_rel_y;
      y2_element=y1_element + element->f_height-1;


      if (   (x >= x1_element)
	  && (x <= x2_element)
	  && (y >= y1_element)
	  && (y <= y2_element)
	 )
	if (element->m_left_button_double_click_event(x,y))
	  return true;
    }

  // Sinon, dans les autres

  node=f_element_list;

  while ((node!=NULL) && (!event))
    {
      if (f_focused_element!=node)
	{
	  element=node->object;
	  x1_element=x1        + element->f_rel_x;
	  x2_element=x1_element + element->f_width-1;
	  y1_element=y1        + element->f_rel_y;
	  y2_element=y1_element + element->f_height-1;

	  if (element->f_enabled)
	    {
	      if (   (x >= x1_element)
		  && (x <= x2_element)
		  && (y >= y1_element)
		  && (y <= y2_element)
		 )
		event=element->m_left_button_double_click_event(x,y);
	    }
	}
      node=node->next;
    }

  return(event);
}

/************************************************************************/
/* m_key_pressed_event : L'utilisateur a appuy sur une touche          */
/* -------------------   qui est propose  l'objet (qui est activable) */
/*                       Retourne true si l'objet est                   */
/*                       intress par cette touche.                    */
/************************************************************************/

bool TGroup::m_key_pressed_event(TKey key)
{
  PObjectNode node;

  PObject element;

  bool event=false;

  // On regarde si l'objet qui a dj le focus est intress par la touche
  // Cet objet est forcment activable

  if (f_focused_element!=NULL)
    if (f_focused_element->object->m_key_pressed_event(key))
      return true;

  // On regarde si c'est la hot-key du groupe

  if (key.hot_character==f_hot_key)
    {
      if (m_set_focus())
	   return true;
    }


  // On regarde si c'est une touche de dplacement entre les objets
  //  condition que le groupe ait le focus

  if (f_focused)
    {
      switch (key.character)
	{
	  case UP        :
	  case LEFT      : return(m_set_focus_to_previous_element());

	  case DOWN      :
	  case RIGHT     : return(m_set_focus_to_next_element());

	  case SHIFT_TAB : return(m_shift_tab_pressed_event());

	  case TAB       : return(m_tab_pressed_event());
	}
    }


  // Sinon, on propose la touche aux autres objets activables
  // que celui qui a le focus

  node=f_element_list;

  while ((node!=NULL) && (!event))
    {
      if (f_focused_element!=node)
	{
	  element=node->object;
	  if (element->f_enabled)
	    event=element->m_key_pressed_event(key);
	}
      node=node->next;
    }

  return(event);
}

/************************************************************************/
/* m_set_focus_to_previous_element : Donne le focus au premier objet    */
/* ------------------------------   possible qui prcde celui qui a le */
/*                                  focus (ne fait rien si aucun objet  */
/*                                  n'est possible ou si aucun n'a le   */
/*                                  focus et retourne false)            */
/*                                  Si l'objet qui a le focus ne veut   */
/*                                  pas le lcher, retourne true.       */
/************************************************************************/

bool TGroup::m_set_focus_to_previous_element()
{
  PObjectNode node;
  PObject     element;

  if (f_focused_element==NULL)
    return false;

  if (!f_focused_element->object->m_can_lose_focus())
    return true;

  node=f_focused_element->last;

  // Parcours de l'objet qui a le focus vers le dbut de la liste des objets

  while (node!=NULL)
    {
      element=node->object;
      if (element->m_focus_can_be_set_by_arrow_key())
        {
          if (element->m_set_focus())
            return true;
        }
      node=node->last;
    }


  // Echec,
  // on repart de la fin vers l'objet qui a le focus

  node=f_last_element;

  while (node!=f_focused_element)
    {
      element=node->object;
      if (element->m_focus_can_be_set_by_arrow_key())
        {
          if (element->m_set_focus())
            return true;
        }
      node=node->last;
    }

  return true;
}


/********************************************************************/
/* m_set_focus_to_next_element : Donne le focus au premier objet     */
/* --------------------------   possible qui suit    celui qui a le */
/*                              focus (ne fait rien si aucun objet  */
/*                              n'est possible ou si aucun n'a le   */
/*                              focus)                              */
/*                              Si l'objet qui a le focus ne veut   */
/*                              pas le lcher, retourne true.       */
/********************************************************************/

bool TGroup::m_set_focus_to_next_element()
{
  PObjectNode node;
  PObject     element;

  if (f_focused_element==NULL)
    return false;

  if (!f_focused_element->object->m_can_lose_focus())
    return true;


  node=f_focused_element->next;

  // Parcours de l'objet qui a le focus vers la fin de la liste des objets

  while (node!=NULL)
    {
      element=node->object;
      if (element->m_focus_can_be_set_by_arrow_key())
        {
          if (element->m_set_focus())
            return true;
        }
      node=node->next;
    }

  // Echec,
  // on repart du dbut vers l'objet qui a le focus

  node=f_element_list;

  while (node!=f_focused_element)
    {
      element=node->object;
      if (element->m_focus_can_be_set_by_arrow_key())
        {
          if (element->m_set_focus())
            return true;
        }
      node=node->next;
    }

  return true;
}


/*ͻ*/
/*                            METHODES PRIVEES                            */
/*ͼ*/

/****************************************************************************/
/* m_tab_pressed_event                                                      */
/*--------------------------------------------------------------------------*/
/* Evnement d'appui sur la touche TAB                                      */
/* Si l'objet qui a le focus ne veut pas le lcher, ne fait rien et retourne*/
/* true                                                                     */
/****************************************************************************/

bool TGroup::m_tab_pressed_event()
{
  PObjectNode node;

  if (f_focused_element==NULL)
    {
      if (f_need_focused_element)
        return false;
      else
        node=f_element_list;
    }
  else
    {
      if (!f_focused_element->object->m_can_lose_focus())
        return true;

      node=f_focused_element->next;
    }

  while (node!=NULL)
    {
      if (node->object->m_set_focus())
	return true;
      node=node->next;
    }

  // On est  la fin des objets du groupe

  // S'il y a un groupe parent, on lui passe la main
  // Sinon, on revient au dbut du groupe


  if (f_parent==NULL)
    {
      node=f_element_list;
      while (node!=f_focused_element)
	{
	  if (node->object->m_set_focus())
	    return true;
	  node=node->next;
	}
    }

  return false;
}

/****************************************************************************/
/* m_shift_tab_pressed_event                                                */
/*--------------------------------------------------------------------------*/
/* Evnement d'appui sur les touches Shift+TAB                              */
/* Si l'objet qui a le focus ne veut pas le lcher, ne fait rien et retourne*/
/* true                                                                     */
/****************************************************************************/

bool TGroup::m_shift_tab_pressed_event()
{
  PObjectNode node;

  if (f_focused_element==NULL)
    return false;

  if (!f_focused_element->object->m_can_lose_focus())
    return true;

  node=f_focused_element->last;
  while (node!=NULL)
    {
      if (node->object->m_set_focus_to_last_element())
	return true;
      node=node->last;
    }

  // On est au dbut des objets du groupe

  if (!f_need_focused_element)
    return(m_set_focus());

  // S'il y a un groupe parent, on lui passe la main
  // Sinon, on revient  la fin du groupe

  if (f_parent==NULL)
   {
      node=f_last_element;
      while (node!=f_focused_element)
	{
	  if (node->object->m_set_focus_to_last_element())
	    return true;
	  node=node->last;
	}
   }

  return false;
}

