#include "msgbox.h"
#include "MessageBox.hpp"
#include "Vocab.h"
#include "Mouse.h"
#include "JPDebug.h"

int	MessageBox(const char* title, const char* message, int windowStyle,
			   int type, TSound soundType,
			   const char* checkBoxTitle, bool checkBoxValue)
{
	int b0 = -1, b1 = -1, b2 = -1;
  	int buttonsType = type & 0x0F;
  	int iconType = type & 0xF0;
  	int defaultButton = (type >> 8) & 0x0F;
	int cancelButton = 1;
	int ret0 = OK_BUTTON;
	int ret1 = CANCEL_BUTTON;
	int ret2 = RETRY_BUTTON;
	if (buttonsType == MB_OK) {
		b0 = VOC_OK_CAPTION;
	} else if (buttonsType == MB_OKCANCEL) {
		b0 = VOC_OK_CAPTION;
		b1 = VOC_CANCEL_CAPTION;
	} else if (buttonsType == MB_OKQUIT) {
		b0 = VOC_OK_CAPTION;
		b1 = VOC_QUIT_CAPTION;
		ret1 = QUIT_BUTTON;
	} else if (buttonsType == MB_ABORTRETRYIGNORE) {
		b0 = VOC_ABORT_CAPTION;
		b1 = VOC_RETRY_CAPTION;
		b2 = VOC_IGNORE_CAPTION;
		cancelButton = 2;
		ret0 = ABORT_BUTTON;
		ret1 = RETRY_BUTTON;
		ret2 = IGNORE_BUTTON;
	} else if (buttonsType == MB_YESNOCANCEL) {
		b0 = VOC_YES_CAPTION;
		b1 = VOC_NO_CAPTION;
		b2 = VOC_CANCEL_CAPTION;
		cancelButton = 2;
		ret0 = YES_BUTTON;
		ret1 = NO_BUTTON;
		ret2 = CANCEL_BUTTON;
	} else if (buttonsType == MB_YESNO) {
		b0 = VOC_YES_CAPTION;
		b1 = VOC_NO_CAPTION;
		ret0 = YES_BUTTON;
		ret1 = NO_BUTTON;
	} else if (buttonsType == MB_RETRYCANCEL) {
		b0 = VOC_RETRY_CAPTION;
		b1 = VOC_CANCEL_CAPTION;
		ret0 = RETRY_BUTTON;
	} else if (buttonsType == MB_CONTINUE) {
		b0 = VOC_CONTINUE_CAPTION;
		ret0 = CONTINUE_BUTTON;
	} else if (buttonsType == MB_YES_NO_REVIEW) {
		b0 = VOC_YES_CAPTION;
		b1 = VOC_NO_CAPTION;
		b2 = VOC_REVIEW_CAPTION;
		cancelButton = 2;
		ret0 = YES_BUTTON;
		ret1 = NO_BUTTON;
		ret2 = REVIEW_BUTTON;
	} else if (buttonsType == MB_YES_NO_RETRY) {
		b0 = VOC_YES_CAPTION;
		b1 = VOC_NO_CAPTION;
		b2 = VOC_RETRY_CAPTION;
		ret0 = YES_BUTTON;
		ret1 = NO_BUTTON;
		ret2 = RETRY_BUTTON;
	} else {
		JPDEBUG_STOP(0);
	}
	jptui::ButtonsBox::ButtonDescr	ds[4];
	ds[0].title_ = b0 != -1 ? GetString(b0) : 0;
	ds[1].title_ = b1 != -1 ? GetString(b1) : 0;
	ds[2].title_ = b2 != -1 ? GetString(b2) : 0;
	ds[3].title_ = 0;
	jptui::MessageBox::Icon icon = jptui::MessageBox::NO_ICON;
	if (iconType == MB_ICONSTOP) {
		icon = jptui::MessageBox::STOP_ICON;
	} else if (iconType == MB_ICONQUESTION) {
		icon = jptui::MessageBox::QUESTION_ICON;
	} else if (iconType == MB_ICONEXCLAMATION) {
		icon = jptui::MessageBox::EXCLAMATION_ICON;
	} else if (iconType == MB_ICONINFORMATION) {
		icon = jptui::MessageBox::INFORMATION_ICON;
	}
	jptui::MessageBox messageBox;
	messageBox.init(title, windowStyle, message, icon, ds, 
				 	defaultButton, cancelButton, 
				    checkBoxTitle, checkBoxValue);
	TMousePointer mousePointer = GetMousePointer();
	SetMousePointer(MP_ARROW);
	PlaySound(soundType);
	int run = messageBox.run();
  	SetMousePointer(mousePointer);
	if (run == 1) {
		ret0 = ret1;
	} else if (run == 2) {
		ret0 = ret2;
	} 
	if (checkBoxTitle != 0 && messageBox.checkBoxValue()) {
		ret0 |= MB_CHECKED_MASK;
	}
	return ret0;
}
