/****************************************************************************/
/* MOUSETC                                                                  */
/*--------------------------------------------------------------------------*/
/* Fonctions de manipulation de la souris                                   */
/*--------------------------------------------------------------------------*/
/* Partie spcifique Turbo/Borland C        				    */
/****************************************************************************/






/****************************************************************************/
/* RestoreBackground                                                        */
/*--------------------------------------------------------------------------*/
/* Restaure les caractres situes sous le curseur de la souris             */
/* (rien n'a t stocke si s_text_x vaut -1)                           */
/****************************************************************************/

static void RestoreBackground()
{
  asm {
	mov   bx,s_screen_ptr
	cmp   bx,-1
	je    EndProc

	mov   di,bx
	mov   ax,0B800h
	mov   es,ax

	mov   cx,s_mouse_pointer_aspect
	cmp   cx,MPA_GRAPHICAL
	jz    Graphical
      }

Text:

  asm {
	mov   ax,es:[di]
	not   ah
	mov   es:[di],ax
	jmp   EndProc
      }

Graphical:

  asm {
	mov   cx,s_text_x
	mov   dx,s_text_y

	push  ds

	mov   si,OFFSET s_pointer_background
	mov   ax,SEG s_pointer_background
	mov   ds,ax

	movsb
	inc   di

	cmp   cx,s_last_col
	jae   Jump

	// Le curseur prend 2 colonnes

	movsb

	cmp   dx,s_last_line
	jae   End

	mov   ax,s_screen_width
	shl   ax,1
	sub   ax,3          // 2*screen_width-3

	add   di,ax
	movsb
	inc   di

	movsb
	jmp   End

      }

Jump:

  asm {
	cmp   dx,s_last_line
	jae   End

	inc   si

	mov   ax,s_screen_width
	shl   ax,1
	sub   ax,2          // 2*screen_width-2

	add   di,ax

	movsb
      }

End:

  asm   pop   ds

EndProc:

}








/****************************************************************************/
/* DisplayMousePointer                                                      */
/*--------------------------------------------------------------------------*/
/* Affiche le curseur souris graphique                                      */
/****************************************************************************/

static void DisplayMousePointer()
{
  word  old_ds;

  char  font[4*MAX_HEIGHT];
  char  *font_ptr=font;

  word  mouse_pointer[MAX_HEIGHT],
	mouse_mask[MAX_HEIGHT]; // Curseur dcal

  int   xo,yo;

  int last_col;
  int last_line;
  int screen_width;
  int gap_mh,gap_32;
  int pointer_height;

  asm {
	mov   cx,s_mouse_pointer_aspect
	cmp   cx,MPA_GRAPHICAL
	jz    Graphical
      }

Text:

      RestoreBackground();

  asm {
	mov   ax,s_graph_y
	mov   s_text_y,ax

	mov   cx,s_graph_x
	mov   s_text_x,cx

	mul   s_screen_width   // dx:ax = s_text_y*screen_width
	shl   ax,1             // ax=s_text_y*2*screen_width

	mov   bx,cx  // bx=s_text_x
	shl   bx,1

	add   ax,bx  // ax=s_text_x*2+(s_text_y*screen_width)
	mov   s_screen_ptr,ax

	mov   di,ax
	mov   ax,0B800h
	mov   es,ax

	mov   ax,es:[di]
	not   ah
	mov   es:[di],ax
	jmp   EndProc
    }

Graphical:

  asm {
	mov   ax,s_screen_width
	mov   screen_width,ax
	dec   ax
	mov   last_col,ax
	mov   ax,s_last_line
	mov   last_line,ax
	mov   ax,s_font_height
	mov   pointer_height,ax
	mov   ax,s_gap_32
	mov   gap_32,ax
	mov   ax,s_gap_max_height
	mov   gap_mh,ax

	mov old_ds,ds
      }










  RestoreBackground();

  // Sauve le fond l o va tre affich le curseur

  asm {
	mov   ax,s_graph_y
	mov   cx,s_font_height
	div   cl
	mov   ah,0
	mov   s_text_y,ax

	mov   dx,ax
	mov   cx,s_graph_x
	shr   cx,3
	mov   s_text_x,cx

	mul   s_screen_width   // dx:ax = s_text_y*screen_width
	shl   ax,1             // ax=s_text_y*2*screen_width

	mov   bx,cx  // bx=s_text_x
	shl   bx,1   // bx=s_text_x*2

	add   ax,bx  // ax=s_text_x*2+(s_text_y*screen_width)
	mov   s_screen_ptr,ax

	mov   si,ax
	mov   ax,SEG s_pointer_background
	mov   es,ax
	mov   di,OFFSET s_pointer_background
	mov   ax,0B800h
	mov   ds,ax

	movsb
	inc   si

	cmp   cx,last_col
	jae   Jump0_1

	movsb

	cmp   dx,last_line
	jae   Jump0_2

	mov   ax,screen_width
	shl   ax,1
	sub   ax,3
	add   si,ax        // 2*screen_width-3
	movsb
	inc   si

	movsb
	jmp   Jump0_2
      }

Jump0_1:

  asm {
	cmp   dx,last_line
	jae   Jump0_2

	inc   di

	mov   ax,screen_width
	shl   ax,1
	sub   ax,2          // 2*screen_width-2

	add   si,ax
	movsb
      }

Jump0_2:











  // Accs linaire  la carte VGA

  outport(0x3c4,0x0402);
  outport(0x3c4,0x0704);
  outport(0x3ce,0x0204);
  outport(0x3ce,0x0005);
  outport(0x3ce,0x0406);

  // Lecture de la dfinition des caractres sous le curseur

  asm {
	les  di,font_ptr
	mov  bx,0
	mov  dx,pointer_height
	shr  dx,1
      }

Loop1_1:

  asm {
	mov  ds,old_ds
	mov  ax,0
	mov  al,byte ptr s_pointer_background[bx]
	shl  ax,5
	mov  si,ax

	mov  ax,0A000h
	mov  ds,ax

	mov  cx,dx
	rep  movsw
	add  di,gap_mh
	inc  bx

	cmp  bx,3
	jle  Loop1_1
      }











  // Construction du curseur

  asm {
	mov ds,old_ds
	mov ax,s_graph_x
	and ax,07
	mov xo,ax

	mov ax,s_graph_y
	mov cx,pointer_height
	div cl
	shr ax,8
	mov yo,ax
      }





  // Dcalage du curseur et du fond en x

 asm {
	mov di,pointer_height
	dec di
	shl di,1
	push di


	mov cx,8
	sub cx,xo
	push cx

	lds si,s_pointer_definition_ptr
	inc si
	add si,pointer_height
      }

Loop2_1:

  asm { mov ah,0
	mov al,[si]
	dec si

	shl ax,cl
	mov word ptr mouse_pointer[di],ax
	sub di,2
	jns Loop2_1
      }

  asm {
	pop cx
	pop di

	add si,di  // 2*(pointer_height-1)
	add si,2
      }

Loop2_2:

  asm { mov ax,0
	mov al,[si]
	dec si

	shl ax,cl
	not ax
	mov word ptr mouse_mask[di],ax

	sub di,2
	jns  Loop2_2
      }







  // Dcalage en y et fusion curseur,masque,fond

  asm {
	mov si,0
	mov di,yo   // di -> o  si -> i
	mov dx,pointer_height
	shl dx,1
      }

Loop3_1:

  asm {
	mov bx,word ptr mouse_mask[si]

	mov cx,word ptr mouse_pointer[si]




	mov al,byte ptr font[di][MAX_HEIGHT]
	and al,bl
	or  al,cl
	mov byte ptr font[di][MAX_HEIGHT],al

	mov al,byte ptr font[di]
	and al,bh
	or  al,ch
	mov byte ptr font[di],al

	inc di
	cmp di,pointer_height
	jne Loop3_2
	mov di,(MAX_HEIGHT*2)
     }

Loop3_2:

  asm { add si,2
	cmp si,dx
	jne Loop3_1
      }












  // Modification de la dfinition des caractres reprsentant la souris

  asm {
	mov  ax,0A000h
	mov  es,ax
	mov  di,GMOUSE_1ST_CHAR
	shl  di,5

	lds  si,font_ptr
	mov  bx,4
	mov  dx,pointer_height
	shr  dx,1
      }

Loop4_1:

  asm { mov  cx,dx
    rep movsw
	add  di,gap_32
	add  si,gap_mh
	dec  bx
	jnz  Loop4_1
      }








  // Accs par plans  la carte VGA

  outport(0x3c4,0x0302);
  outport(0x3c4,0x0304);
  outport(0x3ce,0x0004);
  outport(0x3ce,0x1005);
  outport(0x3ce,0x0E06);

  // Affichage du curseur

  asm {
	mov   ds,old_ds
	mov   di,s_screen_ptr
	mov   ax,0B800h
	mov   es,ax
	mov   cx,s_text_x
	mov   dx,s_text_y

	mov   al,GMOUSE_1ST_CHAR
	mov   es:[di],al
	add   di,2
	inc   al

	cmp   cx,last_col
	jae   Jump5_1

	mov   es:[di],al
	inc   di
	inc   al

	cmp   dx,last_line
	jae   Jump5_2

	mov   bx,screen_width
	shl   bx,1
	sub   bx,3   // 2*screen_width-3
	add   di,bx

	mov   es:[di],al
	add   di,2
	inc   al

	mov   es:[di],al
	jmp   Jump5_2
      }

Jump5_1:

  asm {
	cmp   dx,last_line
	jae   Jump5_2

	mov   bx,screen_width
	shl   bx,1
	sub   bx,2   // 2*screen_width-2

	add   di,bx
	inc   al
	mov   es:[di],al
      }

Jump5_2:

EndProc:

}


/****************************************************************************/
/* MouseMoveEvent                                                           */
/*--------------------------------------------------------------------------*/
/* Evnement appel par le pilote souris en cas de mouvement de celle-ci    */
/****************************************************************************/

static void _saveregs _loadds far MouseMovedEvent()
{
  static bool s_in_event=false;

  if (s_in_event)
    return;

  disable();
  s_in_event=true;

  asm {
	shr cx,3
	shr dx,3
	cmp cx,s_graph_x
	jne PositionChanged
	cmp dx,s_graph_y
	jne PositionChanged
	jmp End
      }

  return;

  PositionChanged:

  asm {
	mov  s_graph_x,cx
	mov  s_graph_y,dx
      }

  if (s_show_state>=0)
    DisplayMousePointer();

  End:

  s_in_event=false;

  enable();
}


