#include <dir.h>
#include <direct.h>
#include <sys/stat.h>
#include <stddef.h>			// NULL
#include "filebox.h"
#include "Callback.hpp"
#include "jpappli.h"		// JP..
#include "twindow.h"
#include "tfilelb.h"
#include "tedzone.h"
#include "tpushbut.h"
#include "tcombbox.h"
#include "vocab.h"
#include "strings.h"
#include "mouse.h"
#include "InputBox.hpp"

namespace {

class CallbacksWrapper : public jptui::Callback
{
public:
	void	operator()(TObject* who, what_type what, item_type item);
};

CallbacksWrapper	callbacksWrapper;

} // namespace

/*ͻ*/
/*                             STATIC VARIABLES                           */
/*ͼ*/

static char                    s_file[MAX_PATH]="";
static char                    s_current_dir_mask[MAX_PATH]="";

static char 		       *s_ok_button_caption=NULL;

static PWindow                 s_window=NULL;
static PEditZone               s_current_path_ez=NULL;
static PComboBox               s_combo_box=NULL;
static PFileListBox            s_file_list_box=NULL;
static PEditZone               s_mask_ez=NULL;
static PPushButton   	       s_ok_button=NULL;

static bool                 s_file_chosen=false;

/*ͻ*/
/*                                 FUNCTIONS                              */
/*ͼ*/

/****************************************************************************/
/* CancelButtonPressedCall                                                  */
/*--------------------------------------------------------------------------*/
/* Function called when the user presses the "cancel" button of the dialog  */
/****************************************************************************/

static void CancelButtonPressedCall(PObject /*sender*/, const char */*arg*/)
{
  JPStop();
}

/****************************************************************************/
/* FileChosenCall                                                           */
/*--------------------------------------------------------------------------*/
/* Function called when a file (or directory) has been chosen in the list-  */
/* box which displays file names					    */
/****************************************************************************/

static void FileChosenCall(PObject /*sender*/, const char */*arg*/)
{
  s_file_chosen=true;
  JPStop();
}

/****************************************************************************/
/* OkButtonPressedCall                                                      */
/*--------------------------------------------------------------------------*/
/* Function called when the user presses the "ok" button of the dialog      */
/****************************************************************************/

static void OKButtonPressedCall(PObject /*sender*/, const char */*arg*/)
{
  PObject object = s_window->m_get_previous_focused_object();
  if (object != NULL) {
    TFLBError error_code;
    if (object->m_get_number() == s_file_list_box->m_get_number())
    { // from s_file_list_box
  	   error_code = s_file_list_box->m_refresh_file_list_from_item(s_file_list_box->m_get_selected_item_index());
  	   if (error_code == FLB_REFRESH_OK_FILE) FileChosenCall(s_file_list_box, "");
      s_file_list_box->m_set_focus();
      return;
    }
  }
  switch (s_file_list_box->m_refresh_file_list(s_mask_ez->m_get_string())) {
    case FLB_REFRESH_OK_FILE:
       FileChosenCall(s_file_list_box,"");
	    break;
    default:
       s_mask_ez->m_set_focus();
  }
}

static void DirChangedCall(PObject /*sender*/, const char */*arg*/);

/*
class DirNameDialog : public OKCancelDialog {
protected:
  char*                       ret_dirname;
  TEditZone*                  dirname_ez;
  virtual bool                ok_pressed(void);
public:
                              DirNameDialog(char* a_ret_dirname);
  virtual void                open(void);
  virtual void                close(void);
};

DirNameDialog::DirNameDialog(char* a_ret_dirname)
 : ret_dirname(a_ret_dirname)
{
  window_height = 9; window_width = 40;
  window_title = "Input Directory Name";
}

void DirNameDialog::open(void)
{
  OKCancelDialog::open();
  int x = 2; int y = 3;
  int frame_width = window_width - 2*x;
  dirname_ez = new TEditZone(window, x, y, frame_width, 0, "", frame_width-2, MAX_PATH);
  dirname_ez -> m_set_focus();
}

void DirNameDialog::close(void)
{
  delete dirname_ez;
  OKCancelDialog::close();
}

bool DirNameDialog::ok_pressed(void)
{
  strcpy(ret_dirname, dirname_ez->m_get_string());
  return true;
}
*/

static void MkDirButtonPressedCall(PObject /*sender*/, const char */*arg*/)
{
//  char dirname[MAX_PATH+1];
//  DirNameDialog* d = new DirNameDialog(dirname);
//  d->open();
//  int ret = d->run();
//  d->close();
//  delete d;
//  if (ret != 0) return;
	jptui::InputBox ib;
	ib.init("Input Directory Name", "", 20, MAX_PATH);
	const char*	dirname;
	if (ib.run() != 0 || (dirname = ib.getString())[0] == 0)
		return;
	char dir[MAX_PATH+1];
	strncpy(dir, s_file_list_box->m_get_current_dir(), MAX_PATH);
	if (EndOfString(dir) != '\\') strcat(dir, "\\");
	strncat(dir, dirname, MAX_PATH);
	mkdir(dir, S_IWUSR);
	DirChangedCall(NULL, "");
	s_file_list_box->m_set_focus();
}

/****************************************************************************/
/* ChangeOkButtonCaptionCall				                    */
/*--------------------------------------------------------------------------*/
/* Function called when the caption of the ok button may have to be changed */
/****************************************************************************/

static void ChangeOkButtonCaptionCall(PObject sender, const char */*arg*/)
{
  static bool s_open_dir_caption = false;
  int   selected_item_index;
  char *item;

  bool open_dir_caption = false;

  PFileListBox list_box = (PFileListBox)sender;

  if (list_box->m_has_focus())
    {
      selected_item_index = list_box->m_get_selected_item_index();

      if (selected_item_index != 0)
	{
	  item=list_box->m_get_item(selected_item_index);
	  if ((item[0]==FLB_PARENT_DIR_CHAR) || (item[0]==FLB_SUB_DIR_CHAR))
	    open_dir_caption=true;
	}
    }

  if (open_dir_caption != s_open_dir_caption)
    {
      s_ok_button->m_set_caption(open_dir_caption 
								 ? GetString(VOC_OPEN_DIRECTORY_CAPTION) 
								 : s_ok_button_caption);

      s_open_dir_caption = open_dir_caption;
    }
}

static void FileRefreshDoneCall(PObject sender, const char */*arg*/);

/****************************************************************************/
/* DirChangedCall                                                           */
/*--------------------------------------------------------------------------*/
/* Function called when a new drive or directory has been chosen in the     */
/* combo box which displays available drives and the parent directories     */
/****************************************************************************/

static void DirChangedCall(PObject /*sender*/, const char */*arg*/)
{
  int first;
  int level;
  register int i;

  char dir_mask[MAX_PATH];
  char *item;

  PSimpleList list=s_combo_box->m_get_list();

  int  selected_item_index=list->m_get_selected_item_index();

  if (selected_item_index==0)
    return;

  item=list->m_get_item(selected_item_index);

  // Drive

  if (item[0]!=' ')
    first=selected_item_index;

  // Sub-directories

  else
    {
      level=2;
      while (item[level]=='\x7')
	level++;
      first=selected_item_index-level+2;
    }

  // New mask of files

  strcpy(dir_mask,list->m_get_item(first));
  level=3;
  for (i=first+1;i<=selected_item_index;i++)
    {
      strcat(dir_mask,(list->m_get_item(i))+level);
      strcat(dir_mask,"\\");
      level++;
    }

  switch (s_file_list_box->m_refresh_file_list(dir_mask))
    {
      case FLB_INVALID_DRIVE    :
      case FLB_NO_DISK_IN_DRIVE	:
      case FLB_INVALID_DIR      :
      case FLB_INVALID_FILE     : FileRefreshDoneCall(s_file_list_box,"");
                                  break;
      default                   : break;
    }
}

/****************************************************************************/
/* FileRefreshDoneCall                                                      */
/*--------------------------------------------------------------------------*/
/* Function called when the list of files is refreshed in                   */
/* the list-box which displays file names				    */
/****************************************************************************/

static void FileRefreshDoneCall(PObject sender, const char */*arg*/)
{
  int item_to_select=0;
  int level;
  char old_char=0;
  char *item;
  char new_item[MAX_PATH];
  char *ptr1,*ptr2;

  char *dir=((TFileListBox *)sender)->m_get_current_dir();

  PSimpleList list=s_combo_box->m_get_list();

  int nb_items;
  register int i;

  int insert_index=0;

  // Disables the combo-box callback

  s_combo_box->stringValidatedAction_.unset();

  s_current_path_ez -> m_enable_modification();
  s_current_path_ez -> m_set_string(dir);
  s_current_path_ez -> m_disable_modification();

  // Updates the combo-box

  i=1;
  nb_items=list->m_get_nb_items();
  while (i<=nb_items)
    {
      item=list->m_get_item(i);
      if (item[1]!=':')
	{
	  list->m_delete_item(i);
	  i--;
	  nb_items--;
	}
      else
	{
	  if (item[0]==dir[0])
	    insert_index=i;
	}
      i++;
    }


  if (insert_index!=0)
    {
      strcpy(new_item,"  ");
      level=strlen(new_item);
      ptr1=strchr(dir,'\\');
      while (ptr1!=NULL)
	{
	  ptr1++;
	  if ((*ptr1)!=0)
	    {
	      ptr2=strchr(ptr1,'\\');
	      if (ptr2!=NULL)
		{
		  old_char=(*ptr2);
		  (*ptr2)=0;
		}
	      new_item[level]='\x7';
	      level++;
	      strcpy(new_item+level,ptr1);
	      if (ptr2!=NULL)
		(*ptr2)=old_char;
	      insert_index++;
	      list->m_insert_item(insert_index,new_item);
	      nb_items++;
	      ptr1=ptr2;
	    }
	  else
	    ptr1=NULL;

	  item_to_select=insert_index;
	}
    }

  if (item_to_select!=0)
    list->m_set_selected_item_index(item_to_select);

  // Updates the file mask editing zone

  s_mask_ez->m_set_string(s_file_list_box->m_get_current_mask());

  // Enables again the combo-box callback

  s_combo_box->stringValidatedAction_.set(callbacksWrapper, 2);	// DirChangedCall
}

void	CallbacksWrapper::operator()(TObject* who, what_type what, item_type item)
{
	if (what == 0) {
		CancelButtonPressedCall(who, 0);
	} else if (what == 1) {
		FileChosenCall(who, 0);
	} else if (what == 2) {
		DirChangedCall(who, 0);
	} else if (what == 3) {
		MkDirButtonPressedCall(who, 0);
	} else if (what == 4) {
		ChangeOkButtonCaptionCall(who, 0);
	} else if (what == 5) {
		FileRefreshDoneCall(who, 0);
	} else if (what == 6) {
		DirChangedCall(who, 0);
	} else if (what == 7) {
		FileRefreshDoneCall(who, 0);
	} else if (what == 8) {
		OKButtonPressedCall(who, 0);
	}
}

/****************************************************************************/
/* File selection box                                                       */
/*--------------------------------------------------------------------------*/
/* Allows the users to select a existing file or enter a new filename       */
/****************************************************************************/

const char*	FileSelectionBox(const char* title, const char* mask,
		       				 const char* okButtonCaption,
		       				 const char* cancelButtonCaption)
{
  char full_path_mask[MAX_PATH];

  TMousePointer pointer;

  // Determines the full path mask

  FullPath(full_path_mask, mask);

  // Saves the captions of buttons

  const char* caption = okButtonCaption[0] == 0 ? GetString(VOC_OK_CAPTION) : okButtonCaption;

  s_ok_button_caption = new char [strlen(caption)+1];
  strcpy(s_ok_button_caption, caption);


  // Allocates the elements of the dialog box

  s_window = new TWindow(DIALOG1, 10, 3, 61, 22, title);

  const char *const DrivesCaption = "~Drives: ";
  s_combo_box = new TComboBox(s_window, 2+DisplayLength(DrivesCaption)+1,
                              2, -DisplayLength(DrivesCaption)-1, 0,
                              DrivesCaption, 52-DisplayLength(DrivesCaption),
                              MAX_PATH, "", 8, NULL, STRING_MUST_BE_IN_LIST,
                              NOT_SORTED);
  {
    char item[] = "X:\\";
    PSimpleList list=s_combo_box->m_get_list();
    for (int disk = 0; disk < 26; disk++) {
      if (DriveExists(disk)) {
	     item[0] = disk + 'A';
        list->m_add_item(item);
      }
    }
  }


  s_file_list_box=new TFileListBox(s_window, 2, 4, 57, 10, s_current_dir_mask);

  int width = 36;
  const char *const pfn_caption = "~File Name:";
  const char *const cp_caption = "Current Path:";
  s_mask_ez = new TEditZone(s_window, 2, 16, (width-DisplayLength(pfn_caption))/2,
                            -1, pfn_caption, width, MAX_PATH, mask);
  s_current_path_ez = new TEditZone(s_window, 2, 19, (width-DisplayLength(cp_caption))/2,
                                    -1, cp_caption, width, MAX_PATH, "");

  s_ok_button = new TPushButton(s_window, 48, 15, 11, s_ok_button_caption,
    PB_DEFAULT);
  s_ok_button->pressedAction_.set(callbacksWrapper, 8); // OKButtonPressedCall

  caption = cancelButtonCaption[0] == 0 ? GetString(VOC_CANCEL_CAPTION) : cancelButtonCaption;
  TPushButton* cancel_button = new TPushButton(s_window, 48, 17, 11, caption,
                                               PB_CANCEL);
  cancel_button->pressedAction_.set(callbacksWrapper, 0); // CancelButtonPressedCall

  TPushButton* mkdir_button = new TPushButton(s_window, 48, 19, 11, "~MkDir",
                                              PB_NORMAL);
  mkdir_button->pressedAction_.set(callbacksWrapper, 3);	// MkDirButtonPressedCall

  // Defines the callbacks

  s_file_list_box->refreshDoneAction_.set(callbacksWrapper, 5);	// FileRefreshDoneCall
  s_file_list_box->fileChosenAction_.set(callbacksWrapper, 1);	// FileChosenCall
  s_file_list_box->focusTakenAction_.set(callbacksWrapper, 4);	// ChangeOkButtonCaptionCall
  s_file_list_box->focusLostAction_.set(callbacksWrapper, 4);	// ChangeOkButtonCaptionCall
  s_file_list_box->selectedItemChangedAction_.set(callbacksWrapper, 4);	// ChangeOkButtonCaptionCall
  s_mask_ez->m_set_focus();

  s_file_list_box->m_refresh_file_list(full_path_mask);

  // Defines the mouse pointer (in case it would have been changed)

  pointer=GetMousePointer();
  SetMousePointer(MP_ARROW);

  // Opens and runs the dialog box

  s_window->m_open();

  s_file_chosen=false;
  JPRunDialog();

  // Has the user pressed the "cancel" button...

  if (!s_file_chosen)
    s_file[0]=0;

  // ... or chosen a filename

  else
    {
      strcpy(s_file,s_file_list_box->m_get_current_dir());
      if (EndOfString(s_file)!='\\')
	strcat(s_file,"\\");
      strcat(s_file,s_file_list_box->m_get_current_mask());

      // The current directory and filename mask are saved into memory.
      // They will be used as default parameters when this dialog will be
      // open again.

      strcpy(s_current_dir_mask,s_file_list_box->m_get_current_dir());
      if (EndOfString(s_current_dir_mask)!='\\')
	strcat(s_current_dir_mask,"\\");
      strcat(s_current_dir_mask,s_file_list_box->m_get_current_mask());
    }

  // Closes the dialog box

  s_window->m_close();
  JPRefresh();

  // Restores the mouse pointer

  SetMousePointer(pointer);

  // Destructs dynamically-allocated objects

  delete s_ok_button;
  delete cancel_button;
  delete mkdir_button;
  delete s_current_path_ez;
  delete s_mask_ez;
  delete s_file_list_box;
  delete s_combo_box;
  delete s_window;

  delete []s_ok_button_caption;

  return(s_file);
}

