#include "ButtonsBox.hpp"
#include "screen.h"			// GetScreen...
#include "strings.h"		// DisplayLength

using namespace jptui;

void	ButtonsBox::init(const char* title, int windowStyle,
				         const ButtonDescr* ds, 
						 int defaultButton, int cancelButton,
						 bool vertical,
						 size_t reserveX, size_t reserveY,
						 bool withInfoBar)
{
	size_t buttonWidth = 0;
	int i = 0;
	for ( ; i < MAX_BUTTONS_NUMBER && ds[i].title_ != 0; ++i) {
		size_t width = 1 + DisplayLength(ds[i].title_) + 1;
		if (buttonWidth < width) {
			buttonWidth = width;
		}
	}
	const int buttonsNumber = i;
	if (cancelButton == -1) {
		cancelButton = buttonsNumber - 1;
	}
	size_t	windowWidth;
	size_t  windowHeight;
	size_t	titleHeight = title[0] != 0 ? 1 : 0;
	const size_t MARGIN_X = vertical ? 2 : 4;
	const size_t SCREEN_WIDTH = GetScreenWidth();
	const size_t SCREEN_HEIGHT = GetScreenHeight();
	const size_t BUTTON_HEIGHT = 2;
	size_t STEP;	// x for horizontal, y for vertical
	if (vertical) {
		windowWidth	= MARGIN_X + buttonWidth + MARGIN_X;
	    STEP = BUTTON_HEIGHT;
		windowHeight = titleHeight + 1 + STEP * buttonsNumber + 1;
	} else {
		const size_t MARGIN_Y = 1;
		const size_t GAP = 2;
		windowWidth = MARGIN_X + (buttonWidth + GAP) * buttonsNumber - GAP + MARGIN_X;
		bool windowWidthChanged = false;
		if (windowWidth < reserveX) {
			windowWidth = reserveX;
			windowWidthChanged = true;
		}
		if (windowWidth > SCREEN_WIDTH) {
			windowWidth = SCREEN_WIDTH;
			windowWidthChanged = true;
		}
		if (windowWidthChanged) {
			buttonWidth = (windowWidth - 2 * MARGIN_X - GAP * (buttonsNumber - 1)) / buttonsNumber;
		}
	    STEP = buttonWidth + GAP;
		windowHeight = titleHeight + MARGIN_Y + reserveY + 3;
		if (windowHeight > SCREEN_HEIGHT) {
			windowHeight = SCREEN_HEIGHT;
		}
	}
	TWindow* window = new TWindow(windowStyle, 
  			 				      (SCREEN_WIDTH - windowWidth) / 2 + 1,
                                  (SCREEN_HEIGHT - windowHeight) / 2 + 1,
                                  windowWidth, windowHeight,
                                  title == 0 ? "" : title,
								  withInfoBar);
	window_.reset(window);
	size_t x = MARGIN_X;
	size_t y = vertical ? (titleHeight + 1) : (windowHeight - BUTTON_HEIGHT - 1);
	for (i = 0; i < buttonsNumber; ++i) {
		int type = PB_NORMAL;
		if (i == defaultButton) {
			type = PB_DEFAULT;
		} else if (i == cancelButton) {
			type = PB_CANCEL;
		}
		TPushButton* button = new TPushButton(window, x, y, buttonWidth,
                                 			  ds[i].title_, type);
		button->pressedAction_.set(*this, i);
		buttons_[i].reset(button);
		if (vertical) {
			y += STEP;
		} else {
			x += STEP;
		}
	}
}
	
int	ButtonsBox::run()
{
	run_ = size_t(-1);
	window_->m_open();
	JPRunDialog();
	window_->m_close();
	return run_;
}

void	ButtonsBox::operator()(TObject* who, what_type what, item_type item)
{
	run_ = what;
	JPStop();
}
