/****************************************************************************/
/* STRINGS                                                                  */
/*--------------------------------------------------------------------------*/
/* Fonctions de manipulation des chanes de caractres (caption,text...)    */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 17/04/95                                                    */
/****************************************************************************/

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>

#include "Const.h"
#include "Types.h"

#include "Strings.h"

/****************************************************************************/
/* EnfOfString                                                              */
/*--------------------------------------------------------------------------*/
/* Returns the last char of string (or 0 if string is "")                   */
/****************************************************************************/

char EndOfString(const char *string)
{
  int length=strlen(string);

  return((length==0)?0:string[length-1]);
}

/****************************************************************************/
/* HexaToInt                                                                */
/*--------------------------------------------------------------------------*/
/* Convertit un chiffre hexadcimal 0-9,a-f ou A-F en nombre entier         */
/****************************************************************************/

int HexaToInt(char hexa_digit)
{
  if (hexa_digit<='9')
    return(hexa_digit-'0');

  if (hexa_digit<='F')
    return(hexa_digit-'A'+10);

  return(hexa_digit-'a'+10);
}

/****************************************************************************/
/* StringToLong                                                             */
/*--------------------------------------------------------------------------*/
/* Convertit une chane en entier long.                                     */
/* Retourne TRUE si la chane tait valide (accepte des espaces en fin).    */
/****************************************************************************/

boolean StringToLong(const char *string, long &value)
{
  char *end_ptr;

  value = strtol(string, &end_ptr, 10);

  // Que des espaces (ou rien)

  if ((end_ptr==string) || ((*(end_ptr-1))==' '))
    return(FALSE);

  // S'il y autre chose que des espaces  la fin

  while ((*end_ptr)!=0)
    {
      if ((*end_ptr)!=' ')
        return(FALSE);
      end_ptr++;
    }
  return(TRUE);
}

/****************************************************************************/
/* StringToDouble                                                           */
/*--------------------------------------------------------------------------*/
/* Convertit une chane en double.                                          */
/* Retourne TRUE si la chane tait valide (accepte des espaces en fin).    */
/****************************************************************************/

boolean StringToDouble(const char *string, double &value)
{
  char *end_ptr;

  value = strtod(string, &end_ptr);

  // Que des espaces (ou rien)

  if ((end_ptr==string) || ((*(end_ptr-1))==' '))
    return(FALSE);

  // S'il y autre chose que des espaces  la fin

  while ((*end_ptr)!=0)
    {
      if ((*end_ptr)!=' ')
        return(FALSE);
      end_ptr++;
    }
  return(TRUE);
}

/****************************************************************************/
/* DoubleToString                                                           */
/*--------------------------------------------------------------------------*/
/* Convertit un double en chane.                                           */
/* La chane doit tre alloue.                                             */
/****************************************************************************/

void DoubleToString(double value,char *string)
{
  sprintf(string,"%.*g",DOUBLE_NB_DIGITS,value);
}

/****************************************************************************/
/* LongToString                                                             */
/*--------------------------------------------------------------------------*/
/* Convertit un entier long en chane.                                      */
/* La chane doit tre alloue.                                             */
/****************************************************************************/

void LongToString(long value,char *string)
{
  sprintf(string,"%ld",value);
}

/*****************************************************/
/* HotKey : Retourne la hotkey de caption (caractre */
/* ------   prcd de ~) ou 0 s'il n'y en a pas     */
/*****************************************************/

char HotKey(const char *caption)
{
  char *ptr=strchr(caption,'~');

  if (ptr==NULL)
    return (0);
  return (toupper(*(ptr+1)));
}

/******************************************************/
/* DisplayLength : Retourne la longueur d'affichage   */
/* -------------   d'une chaine (ne compte pas les ~  */
/*                 suivi d'autre chose qu'un espace   */
/*                 ou un autre ~                      */
/******************************************************/

int DisplayLength(const char *string)
{
  register int i=0;

  while ((*string)!=0)
    {
      if ((*string)!='~')
	i++;
      else
	{
	  switch (*(string+1))
	    {
	      case 0   : i++;
			 break;
	      case '~' : i++;
			 string++;
			 break;
	    }
	}
      string++;
    }

  return i;
}

/**************************************************************/
/* GetTextHeight : Retourne la hauteur d'affichage d'un texte */
/* -------------   (voir STRINGS.H pour le format)            */
/**************************************************************/

int GetTextHeight(const char *text)
{
  boolean  done;

  char    *end_of_line;

  int      nb_lines;

  if (text[0]==0)
    return(0);

  nb_lines=0;
  done=FALSE;
  while (!done)
    {
      end_of_line=strchr(text,'\n');
      if (end_of_line==NULL)
	{
	  done=TRUE;
	  end_of_line=strchr(text,0);
	}

      text=end_of_line+1;
      nb_lines++;
    }

  return(nb_lines);
}

/*************************************************************/
/* GetTextWidth : Retourne la largeur d'affichage d'un texte */
/* ------------   (voir STRINGS.H pour le format)            */
/*************************************************************/

int GetTextWidth(const char *text)
{
  boolean      done;

  char        *end_of_line;
  char         end_character;

  register int line_length;
  int          max_line_length;

  char        *ptr;

  if (text[0]==0)
    return(0);

  max_line_length=0;
  done=FALSE;
  while (!done)
    {
      end_of_line=strchr(text,'\n');
      if (end_of_line==NULL)
        {
          done=TRUE;
	  end_of_line=strchr(text,0);
        }
      end_character=(*end_of_line);
      (*end_of_line)=0;


      /*-----------------------*/
      /* Longueur d'une ligne  */
      /*-----------------------*/

      line_length=0;

      while ((*text)!=0)
        {
          if ((*text)=='[')
            {
	      if ((*(text+1))!='[')
                {
                  ptr=strchr(text,']');
                  if (ptr==NULL)
                    line_length++;
                  else
                    text=ptr;
                }
              else
                {
                  line_length++;
                  text++;
		}
            }
	  else
            line_length++;
	  text++;
        }

      /*------------------------------*/
      /* On passe  la ligne suivante */
      /*------------------------------*/

      max_line_length=MAX(max_line_length,line_length);

      (*end_of_line)=end_character;
      text=end_of_line+1;
    }

  return(max_line_length);
}

