#include <iostream.h>    //next four are standard for GENPREC
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <fstream.h>   //include when doing disk file operations
#include <time.h>      //need this when timing (benchmarking)

const int precision = 8;               
const int zmaxsize=51;                     //for declarations
const int cmaxsize=0;

#include "genprec.h"

//User main starts here
main()
{int i,j,k;

cout<<"prec "<<prec<<'\n';

 double x;        //not used in examples below
 realmp a,b,c,h,zpi;
 zsuppi();                 //run this if pi is needed (trig and inverse trig)
 zsupe();                  //run this if e is needed
 zsuplogsp();              //run this when exp and log functions required

cout<<"  "<<'\n';          //space
cout<<"A number of calculations using genprec.h are made in order to test it."<<'\n';
cout<<"You should devise further tests."<<'\n'; 
cout<<" "<<'\n';
zmessage="enter a 1 to continue after each example";
zbreak();

zpi=pi_mp();  //if you are going to use pi a lot, store it.

                      //examples of file operations in C++
a=3;                                     //write to myfile
a=sqrt(a);
printmp(a);
zmessage="sqrt(3)";
zbreak();

writetofile(a,"myfile.dat");

a=2;                    //just a filler to change a before next 
a=sqrt(a);                          //opening of myfile
printmp(a);
zmessage="sqrt(2)";
zbreak();

readfromfile(a,"myfile.dat");
printmp(a);
zmessage="sqrt(3) loaded from myfile.dat";
zbreak();

zinput[precision+1]=2;
zinput[precision]=3141;
zinput[precision-1]=5926;
zinput[precision-2]=5358;
zinput[precision-3]=9793;
zinput[precision-4]=2384;
zinput[0]=1;               //note exp shift not included here
a<zinputtomp(zinput);
printmp(a);
zmessage="pi assigned to a";
zbreak();

readfromfile(a,"myfile.dat");
printmp(a);
zmessage="repeat sqrt(3) loaded from myfile.dat";
zbreak();

for (i=-10;i<11;i++)        //check of exponential and logarithmic functions
   {a=i;
    b=exp(a);
    printmp(b);
    c=log(b);
    printmp(c);
    zmessage="e^i followed by log(e^i) for i=-10 to 10";
    zbreak();
   }    

a=pi_mp();               //the way pi is called to z in a code
printmp(a);           
zmessage="pi";
zbreak();

a=pi_mp()/6;                //check of sin function
b=sin(a)/2;
printmp(b);         
zmessage="sin(pi/6)/2 should be 1/4";
zbreak();

a=-pi_mp()/6;
b=-sin(a)/2;
printmp(b);
zmessage="sin(-pi/6)/(-2) should be 1/4";
zbreak();

                   //check of arcsin function
a=1;
a=a/2;
b=6*arcsin(a);
printmp(b);      
zmessage="6*arcsin(1/2) should be pi";
zbreak();

a=2*a;             //check of arctan function
b=4*arctan(a);
printmp(b);            
zmessage="4*arctan(1) should be pi";
zbreak();

a=11*pi_mp()+pi_mp()/6;      //check of sin function for large argument
b=sin(a);
printmp(b);             
zmessage="sin(11*pi + pi/6) should be -1/2";
zbreak();

a=-11*pi_mp()-pi_mp()/6;  //check of sin function for large negative argument
b=sin(a);
printmp(b);
zmessage="sin(-11*pi - pi/6) should be 1/2";
zbreak();

a=pi_mp()/3;                    //check of sin function
b=sin(a);
c=b*b;
printmp(c);           
zmessage="sin^2(pi/3) should be 3/4";
zbreak();

a=11*pi_mp()+pi_mp()/3;     //check of sin function for large argument
b=(sin(a))^2;
printmp(b);          
zmessage="sin^2(11*pi + pi/3) should be 3/4";
zbreak();

a=pi_mp()/3;                         //check of cos function
b=cos(a);
printmp(b);          
zmessage="cos(pi/3) should be 1/2";
zbreak();

a=11*pi_mp()+pi_mp()/3;        //check of cos function for large argument
b=cos(a);
printmp(b);            
zmessage="cos(11*pi + pi/3) should be -1/2";
zbreak();

a=-11*pi_mp()-pi_mp()/3;     //check of cos function for large argument
b=cos(a);
printmp(b);            
zmessage="cos(-11*pi - pi/3) should be -1/2";
zbreak();

a=e_mp();              //the way e is called to z
printmp(a);           
zmessage="e";
zbreak();

                //check of sqrt function
a=2;
b=sqrt(a);
printmp(b);             
zmessage="square root of 2";
zbreak();

a=2;  //check of zxtonth
a=(sqrt(a))^10;
printmp(a);
zmessage="(sqrt(2))^10 should be 32";
zbreak();
a=-2;
a=(a^5);
printmp(a);
zmessage="(-2)^5 should be -32";
zbreak();
a=-2;       //a=-2 would require log (-2)
c=(a^-5);                
printmp(c);
zmessage="(-2)^(-5) should be -1/32";
zbreak();
a=-2;
b=-5;
cout<<"note the upcoming error messages resulting from the fact that"<<'\n';
cout<<"b is not in general an integer so a^b is not in general real"<<'\n';
c=a^b;
printmp(c);
cout<<"the result should be -1/32 but abs(a) is taken when miscoded"<<'\n';
zmessage="resulting in 2^-5=+1/32";
zbreak();



          //check of addition, subtraction, multiplication,division.      
a=2;
a=1/a;
b=a;
cout<<"a: ";
printmp(a);
cout<<"b: ";
printmp(b);
zmessage="a and b";
c=a+b;
zmessage="a+b should be 1";
printmp(c);
zbreak();
c=a*b;
printmp(c);
zmessage="a*b should be 1/4";
zbreak();
c=a/b;
printmp(c);
zmessage="a/b should be 1";
zbreak();

zgetout:  //put here so that at any point above one can go here and skip
          //the other examples--when I find a bug in a function I frequently
          //use this code to pin it down, putting an example of the 
          //bad function at the top of this list and skipping to here
return 0;                                
}
