/*
    Copyright (C) 2000 Andrew Zabolotny <bit@eltech.ru>

    Usage of this library is not restricted in any way.
    The full license text can be found in the file dxe.txt.

    This file demonstrates how to load DXE modules with undefined
    external references. When you call dxeload() function you can
    pass a pointer to a certain table which should contain all the
    data required to resolve the undefined external references.
    Also you can set a callback function which will be called as
    a last resort to get the address of a function which's address
    could not be found in the passed table.
*/

#include <stdio.h>
#include <dlfcn.h>

#define MODULE	"test2.dxe"

void extern_func ()
{
  printf ("extern_func () called\n");
}

DXE_EXPORT_TABLE (syms)
  DXE_EXPORT (printf)
  DXE_EXPORT (extern_func)
DXE_EXPORT_END

static int lastresort ()
{
  printf ("last resort function called!\n");
  return 0;
}

void *dxe_res (const char *symname)
{
  printf ("%s: undefined symbol in dynamic module\n", symname);
  return &lastresort;
}

int main ()
{
  // Set the error callback function
  dlsetres (dxe_res);

  // Register the symbols exported into dynamic modules
  dlregsym (syms);

  // Now try to load the module and resolve all unresolved symbols
  dxe_h h = dlopen (MODULE, 0);
  if (!h)
  {
    printf (MODULE ": %s\n", dlerror ());
    exit (-1);
  }

  // Call the test_func() module entry
  int (*test_func) () = (int (*) ())dlsym (h, "test_func");
  if (test_func)
    printf ("test_func: %d\n", test_func ());

  // Call the doit() module function
  int (*doit) () = (int (*) ())dlsym (h, "doit");
  int *x_counter = (int *)dlsym (h, "x_counter");
  if (doit)
  {
    printf ("doit: %d\n", doit ());
    printf ("doit: %d\n", doit ());
  }
  // Set the x_counter variable inside the data segment of the module
  if (x_counter)
    *x_counter = 100;
  if (doit)
  {
    printf ("doit: %d\n", doit ());
    printf ("doit: %d\n", doit ());
  }

  dlclose (h);

  return 0;
}
