/***********************************************


                    CEKANI

      .ANI File Loader Library to DJGPP.

  Copyright (c) 2000 by Cristian EmmericK (CEK)

          E-mail: cek@mailbr.com.br

             ICQ(UIN): 52438873


***********************************************/


#ifndef CEKANI_H
#define CEKANI_H

#ifdef __cplusplus
extern "C" {
#endif


#define CEKANI_VERSION          0
#define CEKANI_SUB_VERSION      1
#define CEKANI_VERSION_STR     "0.01"
#define CEKANI_DATE_STR        "2000"
#define CEKANI_DATE             20000710    /* yyyymmdd */

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "allegro.h"




typedef struct CURSOR_ICON            /* an icon info structure */
{
  unsigned long reserved1;            /* reserved 1 */
  unsigned long type;                 /* type */
  unsigned long count;                /* count */
  unsigned long width;                /* icon width */
  unsigned long height;               /* icon height */
  unsigned long colorcount;           /* color count */
  unsigned long reserved2;            /* reserved 2 */
  unsigned long xhotspot;             /* x hot spot */
  unsigned long yhotspot;             /* y hot spot */
  unsigned long sizeinbytes;          /* size of icon in bytes */
  unsigned long fileoffset;           /* file offset (where header starts) */
  unsigned long ih_width;             /* icon width */
  unsigned long ih_height;            /* icon height plus maked height */
  unsigned long ih_planes;            /* planes */
  unsigned long ih_bitcount;          /* bitcount (color depth) */
  unsigned long ih_compression;       /* compression */
  unsigned long ih_imagesize;         /* image size */
  unsigned long ih_xpixelsperm;       /* x pixels per m */
  unsigned long ih_ypixelsperm;       /* y pixels per m */
  unsigned long ih_colorsused;        /* colors used */
  unsigned long ih_colorsimportant;   /* important colors */

  BITMAP *frame;                      /* icon image */
  BITMAP *maskedframe;                /* icon masked image */
  PALLETE pallete;                    /* icon pallete */

} CURSOR_ICON;



typedef struct CURSOR            /* an animated cursor structure */
{
  unsigned long size;            /* file size */
  unsigned char *inam;           /* info: cursor name (not file name) */
  unsigned char *iart;           /* info: cursor author */
  unsigned long width;           /* width in pixels */
  unsigned long height;          /* height in pixels */
  unsigned long frames;          /* number of stored frames */
  unsigned long steps;           /* number of steps */
  unsigned long cdepth;          /* color depth */
  unsigned long planes;          /* =1 (??) */
  unsigned long drate;           /* display rate */
  unsigned long flag;            /* flags */
  unsigned long rate[1000];      /* animation frame's rate */
  unsigned long seq[1000];       /* animation frame's sequence */

  CURSOR_ICON icon[1000];        /* animation icon's info */

} CURSOR;



long chunck(unsigned char *n);
unsigned char *file_get(unsigned long bytes, FILE *file);
CURSOR *load_ani(unsigned char *filename);



unsigned char *cursor_getname(CURSOR *cursor);
unsigned char *cursor_getauthor(CURSOR *cursor);
unsigned long cursor_getsize(CURSOR *cursor);
int cursor_width(CURSOR *cursor);
int cursor_height(CURSOR *cursor);
int cursor_frames(CURSOR *cursor);
int cursor_steps(CURSOR *cursor);
int cursor_getcolordepth(CURSOR *cursor);
int cursor_rate(CURSOR *cursor, unsigned long number);
int cursor_seq(CURSOR *cursor, unsigned long number);
int cursor_xhotspot(CURSOR *cursor, unsigned long number);
int cursor_yhotspot(CURSOR *cursor, unsigned long number);
BITMAP *cursor_image(CURSOR *cursor, unsigned long number);
PALLETE *cursor_pallete(CURSOR *cursor, unsigned long number);
void cursor_blit(BITMAP *dest, CURSOR *cursor, unsigned long number, unsigned long x, unsigned long y);


#ifdef __cplusplus
}
#endif

#endif
