#include "colour.h"
#include "desktop.h"
#include "error.h"
#include "group.h"
#include "mouse.h"
#include "scrollbr.h"

/*

	scrollbr.c

		Scroll bars for any purpose.

		C-Desktop
		Copyright (C)1998, Brett Porter.

*/

/*
	FUNCTION PROTOTYPES
*/

static	bool	ScrollBar_EventHandler( void *aScrollBar, T_EventRec *aEvent );
static	void	ScrollBar_Draw( T_ScrollBar *aScrollBar, T_EventDrawParameters *aParams );

/*
   FUNCTION DEFINITIONS
*/

T_ScrollBar	*ScrollBar_Initialise( bool aVertical )
{
	T_ScrollBar	*lScrollBar;

	P_InitVar( lScrollBar, T_ScrollBar );

	lScrollBar->fVertical = aVertical;
	lScrollBar->fRelatedObject = NULL;

	DesktopObj_Initialise( lScrollBar, ScrollBar_EventHandler, false );

	return lScrollBar;
}

void	ScrollBar_Draw( T_ScrollBar *aScrollBar, T_EventDrawParameters *aParams )
{
	int	lX1 = aParams->fX;
	int	lY1 = aParams->fY;
	int	lX2 =	lX1+aScrollBar->fWidth-1;
	int	lY2 =	lY1+aScrollBar->fHeight-1;

	int	i;

	T_Buffer	*lBuffer = aParams->fBuffer;

	if ( aScrollBar->fVertical )
	{
		Buffer_Print( lBuffer, lX1, lY1, lX2, lY2, "\x1E", COLOUR_SCROLL_BAR );
		Buffer_Print( lBuffer, lX1, lY2, lX2, lY2, "\x1F", COLOUR_SCROLL_BAR );

		for ( i = lY1+1; i < lY2; i++ )
		{
			const char *lCh = ( i-lY1-1 == aScrollBar->fPosition ) ? "" : "";
			Buffer_Print( lBuffer, lX1, i, lX2, i, lCh, COLOUR_SCROLL_BAR );
		}
	}
	else
	{
		Buffer_Print( lBuffer, lX1, lY1, lX2, lY2, "\x11", COLOUR_SCROLL_BAR );
		Buffer_Print( lBuffer, lX2, lY1, lX2, lY2, "\x10", COLOUR_SCROLL_BAR );

		for ( i = lX1+1; i < lX2; i++ )
		{
			const char *lCh = ( i-lX1-1 == aScrollBar->fPosition ) ? "" : "";
			Buffer_Print( lBuffer, i, lY1, i, lY2, lCh, COLOUR_SCROLL_BAR );
		}
	}
}

bool	ScrollBar_CheckClick( T_ScrollBar *aScrollBar, int aColumn, int aRow, int aX1, int aY1, int aX2, int aY2, void *aObject, int aDelta )
{
/*	int	i;

	if (( aColumn == aX2 && aScrollBar->fVertical ) || ( aRow == aY2 && !aScrollBar->fVertical ))
	{
		if (( aRow == aY1 && aScrollBar->fVertical ) || ( aColumn == aX1 && !aScrollBar->fVertical ))
		{
			i = 0;
			do
			{
				if ( !i )
				{
					i = 1000;
					*aScrollBar->fStartNumPtr -= aDelta;
					if ( *aScrollBar->fStartNumPtr < 0 )
					{
						*aScrollBar->fStartNumPtr = 0;
					}
					Group_RedrawObject( aObject->fOwner, aObject );	/// change to owner group
				}
				else
				{
					i--;
				}
			}
			while ( Mouse_LeftPressed());
		}
		else
		{
			if (( aRow == aY2 && aScrollBar->fVertical ) || ( aColumn == aX2 && !aScrollBar->fVertical ))
			{
				i = 0;
				do
				{
					if ( !i )
					{
						i = 1000;
						*aScrollBar->fStartNumPtr += aDelta;
						if ( *aScrollBar->fStartNumPtr >= *aScrollBar->fCountPtr )
						{
							*aScrollBar->fStartNumPtr = *aScrollBar->fCountPtr-1;
						}
						Group_RedrawObject( gDesktop, aObject ); /// change to owner group
					}
					else
					{
						i--;
					}
				}
				while ( Mouse_LeftPressed());
			}
			else
			{
				if ( aScrollBar->fVertical )
				{
					*aScrollBar->fStartNumPtr = ( aRow-aY1-1 )*( *aScrollBar->fCountPtr )/( aY2-aY1-2 );
				}
				else
				{
					*aScrollBar->fStartNumPtr = ( aColumn-aX1-1 )*( *aScrollBar->fCountPtr )/( aX2-aX1-2 );
				}
				if ( *aScrollBar->fStartNumPtr >= *aScrollBar->fCountPtr )
				{
					*aScrollBar->fStartNumPtr = *aScrollBar->fCountPtr-1;
				}
				Group_RedrawObject( gDesktop, aObject ); /// change to owner group
			}
		}
		return true;
	} */ /// send messages instead
	return false;	///
}

bool	ScrollBar_EventHandler( void *aScrollBar, T_EventRec *aEvent )
{
	bool	lRetVal = false;

	switch ( aEvent->fMessage )
	{
		case	EVENT_KILL:
			lRetVal = true;
			break;
		case	EVENT_CANFOCUS:
		case	EVENT_SHOW:
		case	EVENT_HIDE:
		case	EVENT_KEYPRESS:
			break;
		case	EVENT_DRAW:
			ScrollBar_Draw( aScrollBar, &aEvent->fParameters.fDrawParams );
			break;
		default:
			FatalError( "Unhandled message" );
			break;
	}
	return lRetVal;
}



