#ifndef	__CDESKTOP_CONFIG_H__
#define	__CDESKTOP_CONFIG_H__

#include "misc.h"

#ifdef	__cplusplus
extern "C" {
#endif

/*

	File:	CONFIG.H

	Description:
		Configuration file management functions header file

		C-Desktop
		Copyright (C)1998, Brett Porter.

*/

/*
	# TYPE DEFINITIONS #
*/

typedef	enum	{ CFGVAR_STRING, CFGVAR_INT, CFGVAR_FLOAT }	E_CfgVarType;

/*
	# STRUCTURE DEFINITIONS #
*/

typedef struct S_ConfigVar
{
	char	*fName, *fCmdLineSwitch;

	int	fKey;

	E_CfgVarType	fValueType;

	bool	fSave, fArchive;

	union
	{
		char	*fString;
		int	fInteger;
		float	fFloat;
	} fValue;

	struct S_ConfigVar	*fNext;
} T_ConfigVar;

/*
	# FUNCTION PROTOTYPES #
*/

extern	void	Config_Initialise( void );
extern	void	Config_ParseCommandLine( int argc, char *argv[] );
extern	void	Config_LoadConfigFile( void );
extern	bool	Config_SetVarValue( T_ConfigVar *aVar, const char *aValue );

extern	T_ConfigVar	*Config_RegisterVar( const char *aName, int aKey, const char *aCmdLineSwitch, E_CfgVarType aValType,
											  			const char *aValueStr, bool aSave );
extern	T_ConfigVar	*Config_FindVar( const char *aName );

#ifdef	__cplusplus
}
#endif

#endif	/* __CONFIG_H__ */

