#ifndef	__CDESKTOP_COLOUR_H__
#define	__CDESKTOP_COLOUR_H__

#include "misc.h"

/*

	colour.h

		Colour stuff

		C-Desktop
		Copyright (C)1998, Brett Porter.

*/

/*
	DEFINITIONS
*/

#ifdef	__cplusplus
extern "C" {
#endif

#define	MakeColour(f,b)	((b)<<4)+(f)

#define	COLOUR_BACKGROUND				0
#define	COLOUR_MENU_TEXT				1
#define	COLOUR_MENU_HILITE			2
#define	COLOUR_MENU_SELECT			3
#define	COLOUR_MENU_DISABLED			4
#define	COLOUR_MENU_FRAME				5
#define	COLOUR_DIALOG_FRAME			6
#define	COLOUR_DIALOG_TEXT			7
#define	COLOUR_BUTTON_TEXT			8
#define	COLOUR_BUTTON_SHDW			9
#define	COLOUR_LABEL_HILITE			10
#define	COLOUR_INPUT_TEXT				11
#define	COLOUR_INPUT_ARROW			12
#define	COLOUR_BUTTON_HILITE			13
#define	COLOUR_RADBUT_TEXT			14
#define	COLOUR_RADBUT_FOCUSED		15
#define	COLOUR_LISTBOX_TEXT			16
#define	COLOUR_LISTBOX_SELECT		17
#define	COLOUR_LISTBOX_FOCUS			18
#define	COLOUR_MENU_KEYNAME			19
#define	COLOUR_SCROLL_BAR				20
#define	COLOUR_BUTTON_FOCUSED		21
#define	COLOUR_LABEL_TEXT				22
#define	COLOUR_BUTTON_DEFAULT		23
#define	COLOUR_MENU_HILITE_SEL		24
#define	COLOUR_MENU_KEYNAME_SEL		25

/*
	FUNCTION PROTOTYPES
*/

extern	void	Colour_Initialise( void );
extern	void	Colour_Register( int aColour, const char *aDescription, byte aDefaultAttribute );
extern	void	Colour_SetAttribute( int aColour, byte aAttribute );
extern	byte	Colour_GetAttribute( int aColour );
extern	void	Colour_Modify( void );

#ifdef	__cplusplus
}
#endif

#endif




