#ifndef	__CDESKTOP_BUFFER_H__
#define	__CDESKTOP_BUFFER_H__

#include "misc.h"

#ifdef	__cplusplus
extern "C" {
#endif

/*

	buffer.h

		Draw buffer.

		C-Desktop
		Copyright (C)1998, Brett Porter.

*/

/*
	BUFFER STRUCTURES
*/

typedef struct
{
	int	fWidth, fHeight;
	byte	*fBuffer;
} T_Buffer;

/*
	FUNCTION PROTOTYPES
*/

extern	T_Buffer	*Buffer_Create( int aW, int aH );
extern	void	Buffer_Kill( T_Buffer *aBuffer );
extern	void	Buffer_Print( T_Buffer *aBuffer, int aX1, int aY1, int aX2, int aY2, const char *aStr, int aColour );

#ifdef	__cplusplus
}
#endif

#endif




