/*
 ** BETATRON high level library for platform and action arcade games.
 ** Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
 **
 ** VESACORE.CC: This file is part of the BETATRON library and can be used
 **              and/or distributed only under the terms of the GNU Library
 **              General Public License. See doc/readme.1st for details.
 */



/* xrisimes routines:
   dosmemget:  antigrafei apo real mode deiuthinsi se virtual dieuthinsi
   dosmemput:  antigrafei apo virtual dieuthinsi se real mode dieuthinsi

   __dpmi_physical_address_mapping: kanei map mia fisiki dieuthinsi (mias
				    siskeuis gia paradeigma) se mia linear
				    dieuthinsi
   */


#include <string.h>
#include "vesacore.h"
#include <go32.h>
#include <dpmi.h>
#include <malloc.h>
#include <sys/farptr.h>


/*   1: epitixia
     0: apotixia

     command: 1: save 2: restore
     buf: buffer pou tha topothetithoun ta dedomena, i apo ton opoio tha apo
	  katastathoun
     size: to megethos tou buffer
*/

char pl_saverestoreVBEstate(unsigned char command, char * &buf, short &size)
{
    __dpmi_regs r;

  if (command <1 || command >2) return 0;

  switch (command)
  {
   // save state
   case   1:
	     // prospathise na pareis to megethos tou buffer prota
	     r.x.ax = 0x4F04;
	     r.x.dx = 0;  // o dl mono
	     r.x.cx = 0x000f;	  // sose i apokatestise  controller,BIOS,DAC, register
	     __dpmi_int(0x10, &r);
	     if(r.x.ax!=0x004f) return 0;
	     size=r.x.bx*64;	    // einai se 64ades to megethos tou buffer

	     r.x.ax = 0x4F04;
	     r.x.dx = command;
	     r.x.cx = 0x000F;
	     r.x.es = __tb >> 4;   //  /  16
	     r.x.bx = __tb & 15;   // mod 16
	     __dpmi_int(0x10, &r);
	     if(r.x.ax!=0x004f) return 0;

	     if ( !(buf=(char *)malloc(size)) ) return 0;

	     dosmemget(__tb, size, buf);
	     break;

    // restore state
    case  2:
	     dosmemput(buf,size,__tb);
	     r.x.ax = 0x4F04;
	     r.x.dx = command;
	     r.x.cx = 0x000F;
	     r.x.es = __tb >> 4;   //  /  16
	     r.x.bx = __tb & 15;   // mod 16
	     __dpmi_int(0x10, &r);
	     if(r.x.ax!=0x004f) return 0;
	     break;

    default:
	     return 0;
  }

 return 1;
}




/*
 to tb__ einai alias gia to _go32_info_block.linear_address_of_transfer_buffer
 kai fisika i real mode dieuthinsi i antistoixi einai tb__/16:tb mod 16
 alla epeidi tb__ mod 16 == 0 einai tb__/16:0000
 */

/* TRUE: epitixia
   FALSE: apotixia
*/

char pl_getVBEinfo(char *info)
{
    __dpmi_regs r;
    r.x.ax = 0x4F00;
    r.x.es = __tb / 16;
    r.x.di = 0;
    dosmemput("VBE2",4,__tb);            // plirofories gia VESA 2.0
    __dpmi_int(0x10, &r);
    if(r.x.ax!=0x004f) return 0;

    dosmemget(__tb, VBEINFOSIZE, info);
    return 1;
}


/* TRUE: epitixia
   FALSE: apotixia
*/

char pl_getVBEmodeinfo(char *info, unsigned short mode)
{

    __dpmi_regs r;
      int i;

   // midenise ta prota 512 bytes tou transfer buffer, elpizo oti einai
   // megaliteros
    _farsetsel(_dos_ds);
    for (i=0;i<512/4;i++) _farnspokel(__tb+i,0);

    r.x.ax = 0x4F01;
    r.x.es = __tb / 16;
    r.x.di = 0;
    r.x.cx = mode;
    __dpmi_int(0x10, &r);
    if(r.x.ax!=0x004f) return 0;	 // apotixia

    dosmemget(__tb, VBEMODEINFOSIZE, info);
    return 1;
}


/* TRUE: epitixia
   FALSE: apotixia
*/


char pl_setVBEmode(unsigned short mode)
{
    __dpmi_regs r;
    r.x.ax = 0x4F02;
    r.x.bx = mode;
    __dpmi_int(0x10, &r);
    if(r.x.ax!=0x004f) return 0;	 // apotixia
    return 1;				 // epitixia
}


/* thetei to mikos tis scanline stin epithimiti timi length
   epistrefei 0 an apotixei
   diaforetika to mikos tis grammis pou katafere na thesei
*/
unsigned short pl_setVBEscanlinelength(short length)
{
    __dpmi_regs r;
    r.x.ax = 0x4F06;
    r.x.bx = 0;       // set scanline length in pixels
    r.x.cx = length;  // to mikos tis scanline se pixels
    __dpmi_int(0x10, &r);
    if(r.x.ax!=0x004f) return 0;	 // apotixia
    return r.x.cx;	    // mikos tis scanline se pixels pou tethike telika
			    // ( mporei to mikos na prepei na einai pollaplasio tou
			    //	 4 k.t.l)
}


/*
   to code einai enas deiktis sto table pou epistrefei i antistoixi
   vbe klisi kai periexei ektos ton allon kai ton kodika ton trion functions
   Mnimi gi auto to deikti desmeuetai apo tin idia ti routina
   TRUE: epitixia
   FALSE: apotixia
*/

char pl_getVBEprotectedcode(Tvbefunctions table, char * &code)
{
    __dpmi_regs r;
    r.x.ax = 0x4F0a;
    r.h.bl = 0;
    __dpmi_int(0x10, &r);
    if(r.x.ax!=0x004f) return 0;	 // apotixia
    if ( !(code = (char *) malloc(r.x.cx)) ) return 0;
    dosmemget(r.x.es*16+r.x.di,r.x.cx, code);

    // pare deiktes ston kodika
    table[0]= (Tvbefunction) (code+getfield(code,0,unsigned short));
    table[1]= (Tvbefunction) (code+getfield(code,2,unsigned short));
    table[2]= (Tvbefunction) (code+getfield(code,4,unsigned short));
    return 1;
}







