/*
 * BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 * Copyright (C) 1993-96 by Hartmut Schirmer
 *
 * This library is copyrighted (see above). It might be used and
 * distributed freely as long as all copyright notices are left
 * intact.
 *
 * You may not distribute any changed versions of BCC2GRX without
 * written permission by Hartmut Schirmer.
 *
 * You are permitted to distribute an application linked with BCC2GRX
 * in binary only, provided that the documentation of the program:
 *
 *    a)   informs the user that BCC2GRX is used in the program, AND
 *
 *    b)   provides the user with the necessary information about
 *         how to obtain BCC2GRX. (i.e. ftp site, etc..)
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Contact :                Hartmut Schirmer
 *                          Feldstrasse 118
 *                  D-24105 Kiel
 *                          Germany
 *
 * e-mail : hsc@techfak.uni-kiel.d400.de
 */

#include "text.h"

#ifdef __linux__
#include <ctype.h>
static char *strlwr(char *s)
{
  char *p = s;

  while (*p != '\0') {
    *p = tolower(*p);
    ++p;
  }
  return s;
}
#endif

static int _installgrxfont(int start, int stop, char *name)
{
  __gr_text_init();
  while (start < stop && Fonts[start] != NULL) ++start;
  if (start >= stop)
    return grNoFontMem;
#ifdef GRX_VERSION
  if ( name[0] == '@' && name[1] == ':')
    name += 2;
#endif
  Fonts[start] = (void *) GrLoadFont(name);
  if (Fonts[start] == NULL)
    return grFontNotFound;
  return start;
}

int installuserfont(char *name)
{
  char *loc_name;

  loc_name = alloca(strlen(name)+5);
  if (loc_name != NULL) {
    strcpy(loc_name, name);
    strlwr( loc_name);
    if (strstr(loc_name, ".fnt") != NULL)
      return _installgrxfont( FirstGrxFont, LastGrxFont, name);
  }
  return __gr_text_installfont( FirstUserFont, LastUserFont, name);
}

