/*
 * BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 * Copyright (C) 1993-96 by Hartmut Schirmer
 *
 * This library is copyrighted (see above). It might be used and
 * distributed freely as long as all copyright notices are left
 * intact.
 *
 * You may not distribute any changed versions of BCC2GRX without
 * written permission by Hartmut Schirmer.
 *
 * You are permitted to distribute an application linked with BCC2GRX
 * in binary only, provided that the documentation of the program:
 *
 *    a)   informs the user that BCC2GRX is used in the program, AND
 *
 *    b)   provides the user with the necessary information about
 *         how to obtain BCC2GRX. (i.e. ftp site, etc..)
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Contact :                Hartmut Schirmer
 *                          Feldstrasse 118
 *                  D-24105 Kiel
 *                          Germany
 *
 * e-mail : hsc@techfak.uni-kiel.d400.de
 */

#include "text.h"

/* ----------------------------------------------------------------- */
inline static int xoff(ushort x) {
  /* Csaba did it this way, well done */
  return ((int)(signed char)((x) << 1) >> 1);
}

inline static int yoff(ushort y) {
  return - ((int)(signed char)((y) >> 7) >> 1);
}

/* ----------------------------------------------------------------- */
void __gr_text_vec(int *xx, int *yy, int XX, int YY, uchar *textstring)
{
  if (__gr_TextLineStyle)
    LNE.lno_color= COL|WR;
  if (TXT.direction == HORIZ_DIR) {
    int     _XX, x, y, nx, ny, w;
    ushort *dc;

    switch (TXT.horiz) {
      case CENTER_TEXT : XX -= textwidth(textstring) / 2; break;
      case RIGHT_TEXT  : XX -= textwidth(textstring);     break;
      default          : break;
    }
    switch (TXT.vert) {
      case CENTER_TEXT : YY += textheight(textstring) / 2; break;
      case TOP_TEXT    : YY += textheight(textstring);     break;
      default          : break;
    }
    _XX = XX;
    x = y = 0;
    while (*textstring != '\0') {
      w  = fntptr[*textstring].width;
      dc = fntptr[*textstring].cmd;
      while (dc != NULL) {
	switch ( *dc & 0x8080) {
	  case 0x0000 : dc = NULL;
			XX += w * __gr_text_multx / __gr_text_divx;
			break;
	  case 0x8000 : /* DO_SCAN op, any font using this ? */
			++dc;
			break;
	  case 0x0080 : x = xoff(*dc) * __gr_text_multx / __gr_text_divx;
			y = yoff(*dc) * __gr_text_multy / __gr_text_divy;
			++dc;
			break;
	  case 0x8080 : nx = xoff(*dc) * __gr_text_multx / __gr_text_divx;
			ny = yoff(*dc) * __gr_text_multy / __gr_text_divy;
			if (__gr_TextLineStyle)
			  GrCustomLine( XX+x, YY+y, XX+nx, YY+ny, &LNE);
			else
			  GrLine( XX+x, YY+y, XX+nx, YY+ny, COL);
			x = nx;
			y = ny;
			++dc;
			break;
	}
      }
      ++textstring;
    }
    *xx += XX-_XX;
  } else {
    int     _YY, x, y, nx, ny, w;
    ushort *dc;

    switch (TXT.horiz) {
      case LEFT_TEXT   : XX += textheight(textstring);     break;
      case CENTER_TEXT : XX += textheight(textstring) / 2; break;
      default          : break;
    }
    switch (TXT.vert) {
      case CENTER_TEXT : YY += textwidth(textstring) / 2; break;
      case TOP_TEXT    : YY += textwidth(textstring);     break;
      default          : break;
    }
    _YY = YY;
    x = y = 0;
    while (*textstring != '\0') {
      w  = fntptr[*textstring].width;
      dc = fntptr[*(textstring++)].cmd;
      while (dc != NULL) {
	switch ( *dc & 0x8080) {
	  case 0x0000 : dc = NULL;
			YY -= w * __gr_text_multx / __gr_text_divx;
			break;
	  case 0x8000 : /* DO_SCAN op, any font using this ? */
			++dc;
			break;
	  case 0x0080 : y = -xoff(*dc) * __gr_text_multx / __gr_text_divx;
			x =  yoff(*dc) * __gr_text_multy / __gr_text_divy;
			++dc;
			break;
	  case 0x8080 : ny = -xoff(*dc) * __gr_text_multx / __gr_text_divx;
			nx =  yoff(*dc) * __gr_text_multy / __gr_text_divy;
			if (__gr_TextLineStyle)
			  GrCustomLine( XX+x, YY+y, XX+nx, YY+ny, &LNE);
			else
			  GrLine( XX+x, YY+y, XX+nx, YY+ny, COL);
			x = nx;
			y = ny;
			++dc;
			break;
	}
      }
    }
    *yy -= YY-_YY;
  }
}

