/*
 * BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 * Copyright (C) 1993-96 by Hartmut Schirmer
 *
 * This library is copyrighted (see above). It might be used and
 * distributed freely as long as all copyright notices are left
 * intact.
 *
 * You may not distribute any changed versions of BCC2GRX without
 * written permission by Hartmut Schirmer.
 *
 * You are permitted to distribute an application linked with BCC2GRX
 * in binary only, provided that the documentation of the program:
 *
 *    a)   informs the user that BCC2GRX is used in the program, AND
 *
 *    b)   provides the user with the necessary information about
 *         how to obtain BCC2GRX. (i.e. ftp site, etc..)
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Contact :                Hartmut Schirmer
 *                          Feldstrasse 118
 *                  D-24105 Kiel
 *                          Germany
 *
 * e-mail : hsc@techfak.uni-kiel.d400.de
 */

#include "bccgrx00.h"

#define DEFAULT_PALETTE                                                      \
  { size:16, colors:{EGA_BLACK, EGA_BLUE, EGA_GREEN, EGA_CYAN, EGA_RED,      \
		     EGA_MAGENTA, EGA_BROWN, EGA_LIGHTGRAY, EGA_DARKGRAY,    \
		     EGA_LIGHTBLUE, EGA_LIGHTGREEN, EGA_LIGHTCYAN,           \
		     EGA_LIGHTRED, EGA_LIGHTMAGENTA, EGA_YELLOW, EGA_WHITE} }

struct palettetype __gr_EGAdef = DEFAULT_PALETTE;
static struct palettetype UsrPal = DEFAULT_PALETTE;

/* ----------------------------------------------------------------- */

void __gr_setpalette(int colornum, int color)
{
#ifdef __GO32__
# include <dpmi.h>
  _go32_dpmi_registers regs;

  _DO_INIT_CHECK;
  colornum &= 0x0f;
  color    &= 0x3f;
  UsrPal.colors[colornum] = color;

  memset(&regs, 0, sizeof(regs));
  regs.x.ax = 0x1000;
  regs.x.bx = colornum | (color << 8);
  /* Make library compatible with both DJGPP v1 and v2 */
  #undef _go32_dpmi_simulate_int
  _go32_dpmi_simulate_int(0x10,&regs);
#endif
}
/* ----------------------------------------------------------------- */
void getpalette(struct palettetype  *palette)
{
  _DO_INIT_CHECK;
  *palette = UsrPal;
}

/* ----------------------------------------------------------------- */
void setallpalette(struct palettetype *palette)
{
  int i, col;

  _DO_INIT_CHECK;
  if (palette == NULL)
    return;
  for (i=0; i < palette->size; ++i)
    if ( (col = palette->colors[i]) >= 0)
      __gr_setpalette( i, col);
}
