/*
        SMARTEDIT - A general purpose editor for text files.

        Copyright (C) 1999 Prashant TR
                          B-42, Kudremukh Colony,
                          II Block, Koramangala,
                          Bangalore - 560034.

This program is freeware. You are free to modify and/or redistribute them
under the terms of the GNU General Public License version 2.0 or later.
Read the file COPYING for the license.

The file COPYING.TR contains details about the distribution of this software.

*/

/* ID for this file. */
#define _CLEANUP_C_

#include "editor.h"

extern WINDOW *win;
extern WINDOW winlist[];

void cleanup(void)
{
	TEXT *temp = win -> topline;
	__dpmi_regs regs;
	int f;

	/* Reset blinking attribute */
	regs.x.ax = 0x1003;
	regs.x.bx = 1;
	__dpmi_int(0x10, &regs);

	/* Hide mouse. */
	hidemouse();
	mouseinit();

	/* Reset textcolors. */
	textcolor(7);
	textbackground(0);
	clrscr();

	/* Free all memory used by text. */
	for(f = 0; f < MAXWINDOWS; f++)
	{
		if (!winlist[f].in_use) continue;

		win = &winlist[f];
		while (temp != NULL)
		{
			win -> topline = temp -> next;
			free(temp);
			temp = win -> topline;
		}
	}

	_setcursortype(1);
}