/* getfiledate.c -- get file date 
   Copyright (C) 1999-2000 Wojciech Galazka

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include "lfnsrv.h"

#define USE_GET_FILE_INFO

#ifdef USE_GET_FILE_INFO
static WORD	process_get_file_info_time(
		IN  HANDLE handle,				
		IN  WORD nAction,	
		OUT PWORD pDate,
		OUT PWORD pTime);
#endif

WORD	process_get_date_time(
		IN  SHORT hFile,				
		IN  ULONG pPDB,					
		IN  PVOID * ppSFT,                     		
		IN  PVOID * ppJFT,				
		IN  WORD nAction,	
		OUT PWORD pDate,
		OUT PWORD pTime)
{
	HANDLE handle;
	WORD	result;

	PROLOG(process_get_date_time);
	ISNULL(ppSFT);
	ISNULL(ppJFT);
	ISNULL(pDate);
	ISNULL(pTime); 
	DBGVALUE(hFile,"%d");
	DBGVALUE(nAction,"%d");

	handle = VDDRetrieveNtHandle (pPDB, hFile, ppSFT, ppJFT);
	if (handle == INVALID_HANDLE_VALUE) {
		DBGMSG("invalid handle retrieved");
		result = ERROR_INVALID_HANDLE;
	} else {
		result = process_get_date_time_nt(handle, nAction, pDate, pTime);
		DBGVALUE(*pDate,"%d");
		DBGVALUE(*pTime,"%d");
	}

	EPILOG(process_get_date_time, TRUE);			
	return result;
}

WORD	process_get_date_time_nt(
		IN  HANDLE handle,				
		IN  WORD nAction,	
		OUT PWORD pDate,
		OUT PWORD pTime)
{
	WORD	result;
	FILETIME LocalTime, Used;

	PROLOG(process_get_date_time_nt);
	ISNULL(pDate);
	ISNULL(pTime); 
	DBGVALUE(nAction,"%d");

	result = ERROR_SUCCESS;

	switch (nAction)
	{
  		case GET_LAST_WRITE_DATE:
			if(!GetFileTime(handle, NULL, NULL, &Used)) 
				result = (WORD)GetLastError();
			break;
		case GET_LAST_ACCESS_DATE:
			if(!GetFileTime(handle, NULL, &Used, NULL)); 
				result = (WORD)GetLastError();
			break;
		case GET_CREATION_DATE:	 
			if(!GetFileTime(handle, &Used, NULL, NULL)); 
				result = (WORD)GetLastError();
			break;
		default:
			result = ERROR_INVALID_FUNCTION; 
	}

	if (result) {
		DBGMSG("result 1");
		EPILOG(process_get_date_time_nt, FALSE);			
		return result ;
	}			
 
	if (!FileTimeToLocalFileTime(&Used, &LocalTime)) {
		result = (WORD)GetLastError();
		DBGMSG("result 2");
		EPILOG(process_get_date_time_nt, FALSE);			
		return result ;
	}

	if (!FileTimeToDosDateTime(&LocalTime, pDate, pTime)) {
		result = (WORD)GetLastError();
		DBGMSG("result 3");
		DBGVALUE(result, "%d");
		PrintDateAndTime(&Used);
		PrintDateAndTime(&LocalTime);
#ifdef USE_GET_FILE_INFO
		result = process_get_file_info_time(handle, nAction, pDate, pTime); 
		switch (result)
		{
	 		case ERROR_INVALID_PARAMETER:
				result = process_get_date_time_nt(handle, GET_LAST_WRITE_DATE, pDate, pTime);
				if (result != ERROR_SUCCESS) {
					DBGMSG("result 4");
					EPILOG(process_get_date_time_nt, FALSE);			
					return result ;
				}				
				break;
			case ERROR_SUCCESS:
				break;
			default:
				DBGMSG("result 5");
				EPILOG(process_get_date_time_nt, FALSE);			
				return result ;
		}
#else
		EPILOG(process_get_date_time_nt, FALSE);			
		return result ;
#endif
	}

	DBGVALUE(*pDate,"%d");
	DBGVALUE(*pTime,"%d");
	EPILOG(process_get_date_time_nt, TRUE);			
	return ERROR_SUCCESS;
}

#ifdef USE_GET_FILE_INFO
static WORD	process_get_file_info_time(
		IN  HANDLE handle,				
		IN  WORD nAction,	
		OUT PWORD pDate,
		OUT PWORD pTime)
{
	WORD	result;
	FILETIME LocalTime, Used;
	BY_HANDLE_FILE_INFORMATION fileinfo;

	PROLOG(process_get_file_info_time);
	ISNULL(pDate);
	ISNULL(pTime); 
	DBGVALUE(nAction,"%d");

	if(!GetFileInformationByHandle(handle, &fileinfo)) {
		result =  (WORD)GetLastError();	
		DBGMSG("result 1");
		EPILOG(process_get_file_info_time,FALSE);
		return result;
	}

	switch (nAction)
	{
  		case GET_LAST_WRITE_DATE:
			memcpy(&Used, &fileinfo.ftLastWriteTime, sizeof(Used));
			break;
		case GET_LAST_ACCESS_DATE:
			memcpy(&Used, &fileinfo.ftLastAccessTime, sizeof(Used));
			break;
		case GET_CREATION_DATE:	 
			memcpy(&Used, &fileinfo.ftCreationTime, sizeof(Used));
			break;
		default:
			result = ERROR_INVALID_FUNCTION; 
	}

	if (!FileTimeToLocalFileTime(&Used, &LocalTime)) {
		DBGMSG("result 2");
		result = (WORD)GetLastError();
		EPILOG(process_get_file_info_time, FALSE);			
		return result ;
	}

	if (!FileTimeToDosDateTime(&LocalTime, pDate, pTime)) {
		result = (WORD)GetLastError();
		DBGMSG("result 3");
		PrintDateAndTime(&Used);
		PrintDateAndTime(&LocalTime);
		EPILOG(process_get_file_info_time, FALSE);			
		return result ;
	}

	DBGVALUE(*pDate,"%d");
	DBGVALUE(*pTime,"%d");
	EPILOG(process_get_file_info_time,TRUE);
	return ERROR_SUCCESS;
}
#endif
