/* genshortname.c -- get short filename
   Copyright (C) 1999-2000 Wojciech Galazka

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

//
//	Missing ..
//	ANSI/OEN/UNICODE support
//

#include "lfnsrv.h"


WORD	process_generate_short_filename(
		IN  LPCSTR lpOldFileName,
                OUT LPSTR  lpNewFileName,
		IN BYTE nFormat,
		IN BYTE nCharset)
{
	WORD result;
	PROLOG(process_generate_short_filename);
    	DBGVALUE(nFormat,"%d");
////	DBGVALUE(nCharset,"%d");

	if (nFormat != LONG_GENERATE_SHORT_NAME_FCB &&
	    nFormat != LONG_GENERATE_SHORT_NAME_DOS) {
		EPILOG(process_generate_short_filename, TRUE);
		return ERROR_INVALID_FUNCTION;
        }

	if ((nCharset != LONG_GENERATE_SHORT_NAME_CHARSET(CHARSET_WINDOWS_ANSI, CHARSET_WINDOWS_ANSI)) 	&&			
	    (nCharset != LONG_GENERATE_SHORT_NAME_CHARSET(CHARSET_CURRENT_OEM, CHARSET_WINDOWS_ANSI))  	&&
	    (nCharset != LONG_GENERATE_SHORT_NAME_CHARSET(CHARSET_UNICODE, CHARSET_WINDOWS_ANSI))      	&&
	    (nCharset != LONG_GENERATE_SHORT_NAME_CHARSET(CHARSET_WINDOWS_ANSI, CHARSET_CURRENT_OEM))  	&&			
	    (nCharset != LONG_GENERATE_SHORT_NAME_CHARSET(CHARSET_CURRENT_OEM, CHARSET_CURRENT_OEM))   	&&
	    (nCharset != LONG_GENERATE_SHORT_NAME_CHARSET(CHARSET_UNICODE, CHARSET_CURRENT_OEM))  	&&
	    (nCharset != LONG_GENERATE_SHORT_NAME_CHARSET(CHARSET_WINDOWS_ANSI, CHARSET_UNICODE))  	&&	
	    (nCharset != LONG_GENERATE_SHORT_NAME_CHARSET(CHARSET_CURRENT_OEM, CHARSET_UNICODE))      	&&
	    (nCharset != LONG_GENERATE_SHORT_NAME_CHARSET(CHARSET_UNICODE, CHARSET_UNICODE))           ) 	{
		EPILOG(process_generate_short_filename, TRUE);
		return ERROR_INVALID_FUNCTION;
	}        		
	
	IS_NULL(lpOldFileName, ERROR_FILE_NOT_FOUND);	// not all that true, but ..
	IS_MAX_PATH_SIZE(lpOldFileName);
	IS_NULL(lpNewFileName, ERROR_SUCCESS);
      	DBGVALUE(lpOldFileName,"%s");

	*lpNewFileName = '\0';

	if(!GetShortPathName(lpOldFileName, lpNewFileName, MAX_PATHNAME_SIZE)) {
		result = (WORD)GetLastError();
  		DBGMSG("Cannot generate short filename ");
		DBGVALUE(result,"%d");			

		*lpNewFileName = '\0';

		if (result == ERROR_NOT_SUPPORTED)
			DBGMSG("They say it's not supported");

		if (result == ERROR_NO_MORE_FILES ||
		    result == ERROR_PATH_NOT_FOUND ||
		    result == ERROR_FILE_NOT_FOUND ||
		    result == ERROR_NOT_SUPPORTED )	
		{ 
			char tmpBuf[MAX_PATHNAME_SIZE];
			const char *p = &lpOldFileName[0];
			char *t = &lpNewFileName[0];
			char *s = &tmpBuf[0];
			BYTE points, i =0;

			while (*p == '.')		//initial periods
				p++;
			while (*p) {
				if (*p == ' ') {	//spaces
					p++;
					continue;
				}
				if(*p == 0x22 || *p == 0x2A || 
				   *p == 0x2B || *p == 0x2C ||
				                 *p == 0x2F || 
				   *p == 0x3A || *p == 0x3B ||
				   *p == 0x3C || *p == 0x3D || 
				   *p == 0x3E || *p == 0x3F ||
				   *p == 0x5B || *p == 0x5C || 
				   *p == 0x5D || *p == 0x7C ||
				   *p <  0x20 || *p > 127) {
					*s++ ='_'; 	//illegal characters
         				p++;
					continue;
				}
			  	*s++ = *(char *)p++;
			}	
			while (*--s == '.')            	//trailing periods
				*s = '\0';
			*++s = '\0';		

			s = &tmpBuf[0];
    			DBGVALUE(s,"%s");	
			points = 0;
			while (*s) {
				if (*s++ == '.')
					points++;
			}			
			s = &tmpBuf[0];			
			t = &lpNewFileName[0];
			i = 0;
			if (points == 0) {
				while (*s && i++ < 8)
				 	*t++ = *s++;
                        } else 
			if (points == 1) {
				while (i++ < 8 && *s != '.')
					*t++ = *s++;
				if (i >=8)
					while (*s++ !='.');
				*t++ = *s++;				
				i = 0;
				while (*s && i++ < 3)
					*t++ = *s++;
			} else {  //XXX you are not supposed to understand this
				while (i < 8 && (points > 1 || (points == 1 && *s != '.'))) {
					if (*s == '.') {
						points--;
						s++;
					} else {
						*t++ = *s++;		
						i++;
					}
				}
				if (i >=8)
					while (*s++ !='.');
				*t++ = *s++;				
				i = 0;
				while (*s && i++ < 3)
					*t++ = *s++;						
			}				
        		*t = '\0';	

    			DBGVALUE(lpNewFileName,"%s");
		} else {                                        
			if (result != ERROR_SUCCESS) {
				EPILOG(process_generate_shor t_filename, FALSE);
				return result;		
			}
		}
	} 

    	DBGVALUE(lpNewFileName,"%s");

	if (nFormat == LONG_GENERATE_SHORT_NAME_FCB) {
		char lpszFCBPath[14];
		char *p = &lpszFCBPath[0];
		char *s = &lpNewFileName[0];
		BYTE i = 0;

		while ((*p++ = *s++));		
		p = &lpszFCBPath[0];
		s = &lpNewFileName[0];

		while (*p)  {
			if (*p == '.') {
				while( i++ < 8) {
					*s++ = ' ';
				}	
				p++;	
			} else {
				*s++ = ttoupper(*p++);
				i++;
			}
		}
		while ( i++ < 11)
			*s++ = ' ';	
		*s = '\0';		
    		DBGVALUE(lpNewFileName,"%s");
	}
	
	EPILOG(process_generate_short_filename,TRUE);
	return ERROR_SUCCESS;	
}
