AC_DEFUN(GST_HAVE_TCLTK, [

if test $PLATFORM = unix; then
  AC_REQUIRE([AC_PATH_XTRA])dnl
  echo > /dev/null		# dummy
fi
AC_CACHE_CHECK(how to link with Tcl/Tk 8.0, gst_cv_tcltk_libs, [
  exec AS_MESSAGE_FD>/dev/null

  gst_cv_tcltk_libs="not found"
  # Newer versions are preferred
  for lib in 8.2 82 8.1 81 8.0 80 ""; do
    AC_CHECK_LIB(tcl$lib, Tcl_ObjSetVar2, [
      tcl_libs=-ltcl$lib
      if test $PLATFORM = unix; then
        test have_x=yes || break
        tcl_libs="$tcl_libs $X_PRE_LIBS -lX11 $X_LIBS $X_EXTRA_LIBS"
      fi
      AC_CHECK_LIB(tk$lib, Tk_Init,
        [gst_cv_tcltk_libs="$tcl_libs -ltk$lib"
        break], ,
        $tcl_libs)
    ])
  done
  tcl_libs=
  test "$silent" != yes && exec AS_MESSAGE_FD>&1
])

if test "$gst_cv_tcltk_libs" != "not found"; then
  TCL_LIBS="$gst_cv_tcltk_libs"
  AC_DEFINE(HAVE_TCLTK, 1, [Define if your system has Tcl/Tk, 8.0 or later, installed.])
fi


AC_SUBST(TCL_LIBS)
AC_SUBST(X_CFLAGS)
AC_SUBST(X_EXTRA_LIBS)
AC_SUBST(X_LIBS)
AC_SUBST(X_PRE_LIBS)
])dnl
