/* Copyright (C) 1999, 2000 DJ Delorie, see COPYING.DJ for details */

#include <crt0.h>
#include <stdio.h>
#include <stdlib.h>

static void  __attribute__((constructor)) CheckDJGPPEnvVar (void) 
{
  /* __dos_argv0; */
  char *djdir, *djgpp;
  djdir = getenv("DJDIR");
  if (djdir) return;   // is %DJDIR% is defined then don't check more

  /* Some installation problem found. Let's check slightly deeper */
  fprintf (stderr,"Fatal:\tError in DJGPP instalation\n");
  djgpp = getenv("DJGPP");
  if (!djgpp)
       fprintf (stderr,"\tEnvironment variable DJGPP is not defined\n");
  else if (!__file_exists(djgpp))
       fprintf (stderr,"\tEnvironment variable DJGPP point to file '%s',\n"
                       "\twhich does not exist\n",djgpp);
  else
       fprintf (stderr,"\tEnvironment variable DJGPP points to wrong or "
                       "corrupt file '%s'\n",djgpp);
  exit (16);
}
