#! /bin/sh
#-----------------------------------------------------------------------
#  Configures and builds cross-compiler to DJGPP. Edit file as needed
#
#  I have tested this script on i586-pc-linux-gnu only
#
#  You need stubify somewhere on path and cross-binutils for target
#  i586-pc-msdosdjgpp 
#-----------------------------------------------------------------------

prefix=/usr
source=`(cd ..; pwd)`
_version=`sed -e 's/.*\"\([^ \"]*\)[ \"].*/\1/' < ${source}/gcc/version.c`
target=i586-pc-msdosdjgpp
version_dir=${prefix}/lib/gcc-lib/${target}/${_version}

for name in config.sub configure config.guess move-if-change ; do
    for x in `find ${source} -name ${name}`; do
        chmod 755 ${x}
    done
done    

host_name=`${source}/config.guess`
case $host_name in i[34567]86-*-msdosdjgpp)
    echo ''
    echo 'This script is only intended to build cross-compiler for targets'
    echo 'i[34567]86-pc-msdosdjgpp from a different system (I have only tested'
    echo 'building cross-compiler from i586-pc-linux-gnu to i586-pc-msdosdjgpp)'
    echo ''
    exit 1
esac

if ! [ -d ${version_dir} ]; then
    echo ''
    echo '************************************************************************'
    echo '*'  Please create directory ${version_dir} 
    echo '*'  and rerun this script. This directory must exist to build 
    echo '*'  cross-compiler for target ${target}
    echo '*' 
    echo '*'  Warning: You may need root permissions to do that
    echo '************************************************************************'
    echo ''
    exit 1
fi    


# Looking for required files
files_missing=
stubify_missing=true;
for x in sys-include/limits.h sys-include/float.h sys-include/sys/version.h; do
    test -f $prefix/$target/$x || files_missing="$files_missing $prefix/$target/$x";
done
for dir in `echo $PATH | sed -e 's/:/ /g'`; do
    test -f $dir/stubify && stubify_missing=false;
done    

if $stubify_missing ; then 
    echo "stubify is not found"
    exit 1
fi    

case x$files_missing in x) ;;
    *) echo "Files(s) $files_missing are not found";
       exit 1; ;;
esac

########################################################################################

#  configure in gcc fails to find cross-assembler. Therefore let's help it slightly     
for pref in /usr/bin /usr/local/bin; do
        test -f ${pref}/${target}-as && \
        AS=${AS-${pref}/${target}-as}
done
export AS

export LANGUAGES="c c++ objc f77 `test -d $source/gcc/p && echo pascal`"

###############################################################################
# If we have GNU Pascal sources, then we should make related shell scripts
# executable. Also give some hints for configure in gcc/p/rts as it misdetects
# some stuff
###############################################################################
if [ -d ../gcc/p ] ; then
    chmod -v +x ../gcc/p/script/*
    export ac_cv_func_utime=yes
    export ac_cv_func_select=yes
fi      

###############################################################################
# Let's configure GCC (if it is not done already) 
###############################################################################
if ! [ -f gcc/Makefile ] ; then
    echo Configuring compiler for target ${target} for ${host_name} host

    test -f gcc/Makefile || $source/configure  \
        --target=$target \
        --host=${host_name} \
        --build=${host_name} \
        --prefix=$prefix \
        --verbose \
        --with-gxx-include-dir=$prefix/$target/lang/cxx
fi

#  Make sure we'll not have specs in current directory
rm -f specs

#  Find locations of current gcc specs file. We need this as
#  target specific specs file will be in current directory
orig_specs=`gcc -print-file-name=specs`

#
make       XCFLAGS="-specs=$orig_specs" \
           LDFLAGS="-L`echo $orig_specs | sed -e 's,[/]specs,,g'`" \
           AR_FOR_TARGET=${target}-ar \
           RANLIB_FOR_TARGET=${target}-ranlib \
           CFLAGS=-O2 \
           CXXFLAGS="-O2 -mno-bnu210" \
           LANGUAGES="$LANGUAGES"   || exit 1

mkdir ../install.cross
instdir=`(cd ..; pwd)`/install.cross/${prefix}

make    info install install-info \
        prefix=${instdir} \
        LANGUAGES="$LANGUAGES" \
        gxx_include_dir=${instdir}/$target/lang/cxx

# Let's make installation as close as possible to native one
cat >${instdir}/${target}/lang/cxx/header.gcc << 'EOF'
String.h _String.h
Complex.h _Complex.h
Regex.h _Regex.h
iostreamP.h _iostreamP.h
stl_algobase.h stlalgobase.h
stl_hash_map.h stlhashmap.h
stl_hash_set.h stlhashset.h
stl_hashtable.h stlhashtable.h
stl_multiset.h stlmultiset.h
GetOpt.h _GetOpt.h
EOF

mv ${instdir}/${target}/lang/cxx/GetOpt.h ${instdir}/${target}/lang/cxx/_GetOpt.h

cat >${instdir}/${target}/lang/cxx/std/header.gcc << 'EOF'
valarray_meta.h _valarray_meta.h
EOF
