#!/bin/sh -
# This script runs the .ed scripts generated by mkscripts.sh
# and compares their output against the .r files, which contain
# the correct output.

PATH="$PATH;."
ED=$1
TMP=$2

if test ! -f $ED; then
	echo "$ED: cannot execute"
	exit 1
fi

TESTDIR=`pwd`

cd ${TMP}
if test "$?" -ne 0; then
	echo "${TMP}: cannot cd"
	exit  1
fi

# Run the *.red scripts first, since these don't generate output;
# they exit with non-zero status
for i in *.red; do
	echo $i
	if $i; then
		echo "*** The script $i exited abnormally  ***"
	fi
done >errs.ck 2>&1

# Run error scripts again as pipes - these should generate output and
# exit with error (>0) status.
for i in *.red; do
	base=`expr $i : '\([^.]*\)'`
#	base=`echo $i | sed 's/\..*//'`
#	base=`$ED - \!"echo $i" <<-EOF
#		s/\..*
#	EOF`
	if cat  $base.red | $ED -; then
		echo "*** The piped script $i exited abnormally ***"
	else
		dtou $base.ro
		if cmp -s $base.ro ${TESTDIR}/$base.rr; then :; else
			echo "*** Output ${TMP}$base.ro of piped script ${TMP}$i is incorrect ***"
		fi
	fi
done >pipes.ck 2>&1

# Run the remainding scripts; they exit with zero status
for i in *.ed; do
	base=`expr $i : '\([^.]*\)'`
#	base=`echo $i | sed 's/\..*//'`
#	base=`$ED - \!"echo $i" <<-EOF
#		s/\..*
#	EOF`
	if $base.ed; then
		dtou $base.o
		if cmp -s $base.o ${TESTDIR}/$base.r; then :; else
			echo "*** Output ${TMP}$base.o of script ${TMP}$i is incorrect ***"
		fi
	else
		echo "*** The script ${TMP}$i exited abnormally ***"
	fi
done >scripts.ck 2>&1
