#! /bin/sh
################################################################################
#	This script modifies original distribution of GNU Automake 1.4
#  for building for DJGPP. If You are running this script under DJGPP port
#  of BASH, then LFN support is required. Yoy can run this script on
#  other system (e.g Linux) to get sources of automake-1.4 for DJGPP.
################################################################################
#	Fix one bug in automake.in
################################################################################
patch -Nr automake.in << 'EOF'
*** automake.in~	Fri Jan 15 06:42:36 1999
--- automake.in	Sat Jan 16 18:57:00 1999
***************
*** 6907,6913 ****
  				$trailer = "; error while making link: $!\n";
  			    }
  			}
! 			elsif (! system ('cp', $am_dir . '/' . $file, $errfile))
  			{
  			    $suppress = 0;
  			    $trailer = "\n    error while copying\n";
--- 6907,6913 ----
  				$trailer = "; error while making link: $!\n";
  			    }
  			}
! 			elsif (system ('cp', $am_dir . '/' . $file, $errfile))
  			{
  			    $suppress = 0;
  			    $trailer = "\n    error while copying\n";
EOF
################################################################################
#	Rename some files to fit in MS-DOS 8+3 filename limits
#	Also remove *.info* files as they can be regenerated by makeinfo
#	Fix tests/Makefile.in to use modified file names 
################################################################################
mv -v tests/aclocalii.test tests/aclocal2.test
mv -v tests/link_f_c_cxx.test tests/linkf_c_cxx.test
mv -v tests/link_f_cxx.test tests/linkf_cxx.test
for file in tests/Makefile.am tests/Makefile.in; do
	cat $file | sed -e 's,aclocalii.test,aclocal2.test,g' \
	                -e 's,link_f_c_cxx.test,linkf_c_cxx.test,g' \
		        -e 's,link_f_cxx.test,linkf_cxx.test,g' \
		    >$file
done
autoconf
rm -v *.info*

################################################################################
#	Write DJGPP related scripts
################################################################################
cat >djconfig.sh << 'EOF'
#! /bin/sh
export PATH_SEPARATOR=:
current_drive=`pwd | sed 's,//\(.\).*,\1,'`
export SYSROOT=$current_drive:/
export DEFAULT_LEX=flex
export LEX=flex
export CONFIG_SHELL=bash
export DJPREFIX=//`echo $DJDIR | sed -e 's,:/,/,'`
export INSTALL=$DJPREFIX/bin/ginstall.exe
export ac_cv_path_PERL=perl
#
./configure --verbose --prefix=$DJDIR
EOF
#===============================================================================
cat >djmake.sh << 'EOF'
#! /bin/sh
# just in case
export PATH_SEPARATOR=:
export CONFIG_SHELL=bash
current_drive=`pwd | sed 's,//\(.\).*,\1,'`
export SYSROOT=$current_drive:/
make $*
EOF
#===============================================================================
cat >djfix.sh << 'EOF'
./configure --verbose --prefix=$DJDIR
#! /bin/sh
DJPREFIX=//`echo $DJDIR | sed -e 's,:/,/,'`

for file in aclocal automake; do
	sed -e "s,\"$DJDIR\",\$ENV{\"DJDIR\"}," $file >$file.new
	mv -f $file.new $file;
done
EOF
#===============================================================================

