#ifndef __CEDITINT_H_SET_
#define __CEDITINT_H_SET_

// Configuration for the Editor:

//#define SET
#define ROBERT
//#define ML

#ifdef SET
#define BIOS_KEYBOARD
#define STANDALONE
#define SAVE_ALL_VARS
#define CACHED_COLORS
#define RHIDE
#endif

#ifdef ROBERT
#define BIOS_KEYBOARD
#define RHIDE
#define SAVE_ALL_VARS
#define CACHED_COLORS
#endif

#ifdef ML
#define BIOS_KEYBOARD
#define STANDALONE
#define SAVE_ALL_VARS
#define CACHED_COLORS
#endif

#if !defined(NO_INTL_SUP)
// International support via gettext only in the GNU version
#include "intl.h"
#else
#include "nointl.h"
#endif

// Tabs setings

#ifdef Tabs8
#define AdvanceWithTab(a,b)     if (a==9) b|=7; b++
#define NextTabPos(x)           (((x/8)+1)*8)
#define MoveWithTab(b)          b|=7; b++
#define IsATabPos(a)            (a%8)==0
#else
#define AdvanceWithTab(a,b)     if (a==9) b+=tabSize-(b%tabSize); else b++
#define NextTabPos(x)           (((x/tabSize)+1)*tabSize)
#define MoveWithTab(b)          b+=tabSize-(b%tabSize)
#define IsATabPos(a)            (a%tabSize)==0
#endif

#define IsntEOL(a) (a!='\r' && a!='\n')
#define IsEOL(a)   (a=='\r' || a=='\n')
#ifdef __DJGPP__
#define LenEOL     2
const char crlf[] = "\r\n";
#define USE_CRLF
#else
#define LenEOL     1
const char crlf[] = "\n";
#endif

#ifndef __DJGPP__
// This condition is weak, I know, but by now is enough
extern "C" char *strlwr(char *s);
#define NEEDS_STRLWR
extern "C" char *strupr(char *s);
#define NEEDS_STRUPR
#define stricmp  strcasecmp
#define strnicmp strncasecmp

#ifndef O_BINARY
#define O_BINARY 0
#endif

#endif

#endif // __CEDITINT_H_SET_
