// MessageView.cpp : implementation file
//

#include "stdafx.h"
#include "DFE32.h"
#include "MessageView.h"
#include "dfe32doc.h"
#include "dfe32view.h"
#include "childfrm.h"
#include "mainfrm.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMessageView

IMPLEMENT_DYNCREATE(CMessageView, CFormView)

CMessageView::CMessageView()
	: CFormView(CMessageView::IDD)
{
	//{{AFX_DATA_INIT(CMessageView)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

CMessageView::~CMessageView()
{
}

void CMessageView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMessageView)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMessageView, CFormView)
	//{{AFX_MSG_MAP(CMessageView)
	ON_COMMAND(ID_MESSAGES_CLEARMESSAGES, OnMessagesClearmessages)
	ON_COMMAND(ID_MESSAGES_COPYRIGHTANDVERSION, OnMessagesCopyrightandversion)
	ON_COMMAND(ID_MESSAGES_TIP, OnMessagesTip)
	ON_LBN_DBLCLK(IDC_MESSAGE_LIST, OnDblclkMessageList)
	ON_WM_CONTEXTMENU()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMessageView diagnostics

#ifdef _DEBUG
void CMessageView::AssertValid() const
{
	CFormView::AssertValid();
}

void CMessageView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMessageView message handlers

void CMessageView::OnMessagesClearmessages() 
{
	// TODO: Add your command handler code here
	Reset();
}

void CMessageView::OnInitialUpdate() 
{
	CFormView::OnInitialUpdate();
	
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit(FALSE);
	OnMessagesCopyrightandversion(); 
}

void CMessageView::PostMessage(CString str, BOOL mode)
{
	CListBox *list = (CListBox *)GetDlgItem(IDC_MESSAGE_LIST);
	if (mode == TRUE)
	{
		list->AddString(str);
		list->AddString("-");
		list->SetCurSel(list->GetCount() - 2);
	}
	else
	{
		list->AddString(str);
		list->SetCurSel(list->GetCount() - 1);
	}
}
void CMessageView::OnMessagesCopyrightandversion() 
{
	// TODO: Add your command handler code here
	CString str("DFE95 version 3.2 Copyright 1998 Will Weisser, All Rights Reserved");
	PostMessage(str, TRUE);
}

void CMessageView::OnMessagesTip() 
{
	// TODO: Add your command handler code here
	CString str;
	static int i = 0;
	static int lastint = 0;
	while (i == lastint)
	{
		i = (rand() % 15) + 1;
	}
	lastint = i;
	switch (i)
	{
	case 1:
		str = "Brushing your teeth after meals prevents cavities";
		break;
	case 2:
		str = "Remember to link with libiostr.a when compiling c++ files that use the iostream library";
		break;
	case 3:
		str = "You can right-click anywhere to bring up menus, even with no source file present";
		break;
	case 4:
		str = "Double clicking on an error message or project listing brings up the associated file";
		break;
	case 5:
		str = "If you're having trouble, send email to kased811@ix.netcom.com";
		break;
	case 6:
		str = "Always save files before attempting to compile them!";
		break;
	case 7:
		str = "Select \"Rebuild All\" to build files in which only the headers have changed";
		break;
	case 8:
		str = "DFE95 homepage: http://pages.infinit.net/x86/jcouture/dfe95/index.html";
		break;
	case 9:
		str = "Remember to set your gcc path in the options menu";
		break;
	case 10:
		str = "Relax and take a deep breath...it's only code!";
		break;
	case 11:
		str = "DJGPP homepage: http://www.delorie.com/djgpp/";
		break;
	case 12:
		str = "You can use the -ansi option to make sure your program complies with the ANSI standard";
		break;
	case 13:
		str = "You can save the contents of this window to disk by pressing the save button on the toolbar";
		break;
	case 14:
		str = "Shouldn't you be coding instead of looking at useless tips?";
		break;
	case 15:
		str = "If you have trouble compiling a project, export it as a makefile";
		break;
	}
	PostMessage(str, TRUE);
}

void CMessageView::Reset(void)
{
	CListBox *list = (CListBox *)GetDlgItem(IDC_MESSAGE_LIST);
	list->ResetContent();
}
void CMessageView::OnDblclkMessageList() 
{
	// TODO: Add your control notification handler code here
	CListBox *list = (CListBox *)GetDlgItem(IDC_MESSAGE_LIST);
	CString str, filename;
	CDocument *doc;
	POSITION pos;
	BOOL foundline = FALSE;
	char lastchar = 0;
	int index, index2, index3;
	int strindex = 0;
	char buffer[500], filebuffer[500];
	int lineno;
	memset(buffer, '\0', 450);
	memset(filebuffer, '\0', 450);
	list->GetText(list->GetCurSel(),str);
	if (str.Find(":") != -1)
	{
		index = 0;
		while(index < (str.GetLength() - 3))
		{
			index++;
			//try to find :
			if (str.GetAt(index) == ':')
			{
				index++;
				// look for numbers, then trailing colon
				while(str.GetAt(index) >= '0' && str.GetAt(index) <= '9')
				{
				buffer[strindex] = str.GetAt(index);
				strindex++;
				index++;
				}
				// if not found, continue
				if (str.GetAt(index) != ':')
					continue;
				else
				{
					foundline = TRUE;
					break;
				}
			}
		}
		// woo hoo! if everything went well we have buffer filled with our 
		// line number
		if (foundline)
		{
			lineno = atoi(buffer);
			filename = str.Left(index - strlen(buffer) - 1);
			index3 = 0;
			for (index2 = 0; index2 < filename.GetLength(); index2++)
			{
				if (lastchar != filename.GetAt(index2) || lastchar != '\\')
				{
						filebuffer[index3] = filename.GetAt(index2);
						index3++;
				}
				lastchar = filename.GetAt(index2);
			}
			filename = filebuffer;
			doc = AfxGetApp()->OpenDocumentFile(filename);
			if (doc != NULL)
			{
				pos = doc->GetFirstViewPosition();
				CDFE32View *view = (CDFE32View *)doc->GetNextView(pos); 
				CEdit &edit = view->GetEditCtrl();
				if (edit.LineIndex(lineno < 0))
				{
					edit.SetSel(edit.LineIndex(0), edit.LineIndex(1) - 2);
				}
				else if (edit.LineIndex(lineno) == -1)
				{
					edit.SetSel(edit.LineIndex(edit.GetLineCount() - 1), 
						edit.LineIndex(edit.GetLineCount()) - 2);
				}
				else
					edit.SetSel(edit.LineIndex(lineno - 1), 
						edit.LineIndex(lineno) - 2);
			}
		}
	}
}

void CMessageView::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	// TODO: Add your message handler code here
	GetParentFrame()->ActivateFrame();
	CMenu menu;
	if (menu.LoadMenu(IDR_MESSAGEPOP_MENU))
	{
		CMenu* pPopup = menu.GetSubMenu(0);
		ASSERT(pPopup != NULL);
		pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,point.x, point.y,
			AfxGetMainWnd());
	}	
}
