/* $Id: upgrade.h,v 1.10 2002/06/23 20:28:31 richdawe Exp $ */

/*
 *  upgrade.h - Header for upgrade routines for pakke
 *  Copyright (C) 2001, 2002 by Richard Dawe
 *      
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __pakke_upgrade_h__
#define __pakke_upgrade_h__

/* Upgrade modifiers */
enum {
  UPM_NONE = 0x00,
  UPM_TEST = 0x01
};

/* --- Structures --- */
typedef struct {
  int	 op;                /* Upgrade operation                       */
  int	 mod;               /* Upgrade modifier                        */
  int	 verbosity;         /* Upgrade verbosity                       */
  int    interactive;       /* Ask the user questions?                 */
  char	*root;              /* DJGPP/spec'd root directory             */
  char  *prefix;            /* Prefix to install upgraded package into */
  char  *backup_prefix;     /* Prefix to store backups under           */
  char  *download_prefix;   /* Prefix to store downloaded archives     */
  char	*name;              /* Upgrade package name                    */
  char **dsm_path;          /* Upgraded DSM file list                  */
  char **dsm_path_avail;    /* Available DSM path list                 */
  char **mft_path;          /* Upgraded manifest file list             */
  char **zip_path;          /* Path to .zip files                      */
  char **tar_gzip_path;     /* Path to .tar.gz files                   */
  char **tar_bzip2_path;    /* Path to .tar.bz2 files                  */
} PAKKE_UPGRADE;

/* --- Functions --- */
extern int perform_upgrade (const PAKKE_UPGRADE *req);

extern int perform_upgrade_avail (const PAKKE_UPGRADE *req);

#endif /* __pakke_upgrade_h__ */
