/* $Id: initdb.h,v 1.7 2002/06/23 20:28:30 richdawe Exp $ */

/*
 *  initdb.h - Header for database initialisation routines for pakke
 *  Copyright (C) 1999-2002 by Richard Dawe
 *      
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __pakke_initdb_h__
#define __pakke_initdb_h__

/* --- Structures --- */

/* Database initialisation */
typedef struct {
  int	 op;           /* db initialisation operation      */
  int	 mod;          /* db initialisation modifier       */
  int	 verbosity;    /* Verbosity of db initialisation   */
  int    interactive;  /* Ask the user questions?          */
  char	*root;         /* DJGPP/spec'd root directory      */
  char	*prefix;       /* Prefix to use for non-db actions */
  char **platforms;    /* Platform DSMs to put in db       */
  char	*pakke;        /* Executable name, if duplicating. */
  int    with_helpers; /* Initialise helpers too?          */
} PAKKE_INITDB;

/* --- Functions --- */
extern int perform_initdb (const PAKKE_INITDB *req);

#endif	/* __pakke_initdb_h__ */
