/* Project SWORD
   V2.0

   SubSystem : Basic objects, General use mecanisms
   File      : Src/Mecanism/Disk.CC
   Author    : Eric NICOLAS
   Overview  : Object for accessing disks or other DOS peripherals
   UpDate    : Oct 02, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Disk.H"

void TDisk::Open(char* Name, int Acces)
{
#ifdef __TURBOC__
  ToAntiSlash(Name);
#endif
  char Access[10];
  switch(Acces & (stCreate | stOpen))
  { case stCreate :
      strcpy(Access,"w");
      break;
    case stOpen :
      strcpy(Access,"r");
      break;
    default :
      Error=erDiskAccess_Open;
      return;
  }
  if (Acces & stTextMode) strcat(Access,"t");
                     else strcat(Access,"b");
  if ((FileHandle=fopen(Name,Access))==NULL) Error=erDiskAccess_Open;
#ifdef __TURBOC__
  ToSlash(Name);
#endif
}

void TDisk::Close(void)
{ if (!Error)
    if (!(fclose(FileHandle))) Error=erDiskAccess_Close;
}

void TDisk::Write(void* Buffer, int Size)
{ if (!Error)
    if (fwrite(Buffer,1,Size,FileHandle)!=Size) Error=erDiskAccess_Write;
}

void TDisk::Read(void* Buffer, int Size)
{ if (!Error)
  { LastRead=fread(Buffer,1,Size,FileHandle);
    if (LastRead!=Size)
      if (LastRead) Error=erDiskAccess_EOF;
	           else Error=erDiskAccess_Read;
  }
}

// ------------------------------------------------------------------------

long TDisk::Seek(long Depl, char Mode)
{ if (!Error)
    if (fseek(FileHandle,Depl,Mode))
    { Error=erDiskAccess_Seek;
      return 0L;
    }
    else return Depl;
  return 0L;
}

long TDisk::Position(void)
{ return ftell(FileHandle);
}

void TDisk::ReadLn(char *Buffer, int MaxLength)
{ if (!Error)
    if (fgets(Buffer,MaxLength,FileHandle)==NULL) Error=erDiskAccess_EOF;
    else
    { // Remove \n char from string
      char *P=strchr(Buffer,'\n');
      if (P!=NULL) *P=0;
    }
}

void TDisk::WriteLn(char *Buffer)
{ if (!Error) fprintf(FileHandle,"%s\n",Buffer);
}
