/* Project SWORD
   V2.0

   SubSystem : Little usefull graphical objects
   File      : Src/Gadgets/WFrame.CC
   Author    : Eric NICOLAS
   Overview  : TWindowFrame object = Visible frame of a window
   UpDate    : May 22, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"
#include "Drawings/Drawings.H"
#include "Gadgets/Gadgets.H"

short RegTWindowFrameCorner;
short RegTWindowFrame;
short RegTWindowBack;
char *IdentTWindowFrameCorner = "TWindowFrameCorner";
char *IdentTWindowFrame       = "TWindowFrame";
char *IdentTWindowBack        = "TWindowBack";

// ----- TWindowFrameCorner

TWindowFrameCorner::TWindowFrameCorner() : TZone()
{ Init();
}

TWindowFrameCorner::TWindowFrameCorner(int X, int Y, char *Descr, int NCurs,
                                       int eNumber, int eOptions) :
                                       TZone(X,Y,10,10)
{ Init(Descr,NCurs,eNumber,eOptions);
}

void TWindowFrameCorner::Init(char *Descr, int NCurs, int eNumber, int eOptions)
{ Register=RegTWindowFrameCorner;
  Ident=IdentTWindowFrameCorner;
  SetOptions(eOptions);
  Number=eNumber;
  if (NCurs)
    MouseAspect=NCurs;
  if (Descr!=NULL)
    Drawing=new TSysIcone(10,10,Descr);
}

TWindowFrameCorner::~TWindowFrameCorner()
{ delete Drawing;
}

void TWindowFrameCorner::Draw(TRect& )
{ Drawing->Draw(Corner.X(),Corner.Y());
}

void TWindowFrameCorner::SetColorGroup(char ColorGroup)
{ Drawing->SetColorGroup(ColorGroup);
  TZone::SetColorGroup(ColorGroup);
}

boolean TWindowFrameCorner::MouseLDown(TPoint& Where, int )
{ if (GetStatus(sfMouseIn))
  { Father()->ChangeSize(Number,Where);
    return TRUE;
  }
  return FALSE;
}

// ----- TWindowFrame

// Constructors

TWindowFrame::TWindowFrame() : TZone()
{ Init();
}

TWindowFrame::TWindowFrame(int X, int Y, int L, int H, boolean Sizeable) :
  TZone(X,Y,L,H)
{ Init(Sizeable);
}

TWindowFrame::TWindowFrame(TRect& R, boolean Sizeable) : TZone(R)
{ Init(Sizeable);
}

void TWindowFrame::Init(boolean Sizeable)
{ Register=RegTWindowFrame;
  Ident=IdentTWindowFrame;
  SetOptions(opCSHiX | opCSHiY);
  if (Sizeable)
  { int L=Where.L(), H=Where.H();
    Insert(new TWindowFrameCorner(0   ,0   ,ICO_Frame1,MouseCursorSize1,1,0));
    Insert(new TWindowFrameCorner(L-10,0   ,ICO_Frame2,MouseCursorSize2,2,opCSHiX | opCSLoX));
    Insert(new TWindowFrameCorner(L-10,H-10,ICO_Frame3,MouseCursorSize1,3,opCSAll));
    Insert(new TWindowFrameCorner(0   ,H-10,ICO_Frame4,MouseCursorSize2,4,opCSHiY | opCSLoY));
  }
}

TWindowFrame::~TWindowFrame(void)
{ if (!Destroyed)
  { Done();
    Destroyed=TRUE;
  }
}

// Graphics

void TWindowFrame::Draw(TRect& )
{ int Active=Father()->GetStatus(sfSelected);
  int L=Where.L();
  int H=Where.H();
  // Cadre
  if (Active) SetSysColor(GetColor(DarkGray));
         else SetSysColor(GetColor(Black));
    Rectangle(2,2,L-3,H-3);
    Rectangle(3,3,L-4,H-4);
  SetSysColor(GetColor(LightGray));
    Rectangle(4,4,L-5,H-5);
}

void TWindowFrame::ShrinkInside(TRect& InsideFather)
{ InsideFather.P1()+=TPoint(5,5);
  InsideFather.P2()-=TPoint(5,5);
}

boolean TWindowFrame::HandleCommand(long Command, char , short , long , void *)
{ if ((Command==cmSelect)||(Command==cmUnSelect))
  { int L=Where.L();
	 int H=Where.H();
	 Invalidate(0,0,L-1,4);
	 Invalidate(0,H-5,L-1,H-1);
	 Invalidate(0,5,4,H-6);
	 Invalidate(L-5,5,L-1,H-6);
  }
  return FALSE;
}

void TWindowFrame::ChangeSize(int CornerNo, TPoint mWhere)
{ //
  TEvent   Event;
  TWindow *W=Father();
  int      X1,Y1,X2,Y2;
  int      dX1,dY1,dX2,dY2;
  int      SX,SY,dX,dY;
  //,dXs,dYs;
  TRect    Rect;
  X1=W->Corner.X();
  Y1=W->Corner.Y();
  X2=X1+W->Where.L()-1;
  Y2=Y1+W->Where.H()-1;
  SX=W->MinimalSize.X();
  SY=W->MinimalSize.Y();
  switch(CornerNo)
  { case 1 :
      MouseWarp(X1,Y1);
      MouseSetLimits(0,0,X2-SX+1,Y2-SY+1);
      MouseSetCursorMode(M_CUR_RUBBER,X2,Y2,NoSysColor[15]);
      break;
    case 2 :
      MouseWarp(X2,Y1);
      MouseSetLimits(X1+SX-1,0,GrMaxX(),Y2-SY+1);
      MouseSetCursorMode(M_CUR_RUBBER,X1,Y2,NoSysColor[15]);
      break;
    case 3 :
      MouseWarp(X2,Y2);
      MouseSetLimits(X1+SX-1,Y1+SY-1,GrMaxX(),GrMaxY());
      MouseSetCursorMode(M_CUR_RUBBER,X1,Y1,NoSysColor[15]);
      break;
    case 4 :
      MouseWarp(X1,Y2);
      MouseSetLimits(0,Y1+SY-1,X2-SX+1,GrMaxY());
      MouseSetCursorMode(M_CUR_RUBBER,X2,Y1,NoSysColor[15]);
      break;
  }
  do
  { GetEvent(&Event);
  } while(Event.What!=evMouseLUp);
  MouseSetCursorMode(M_CUR_NORMAL);
  MouseSetLimits(0,0,GrMaxX(),GrMaxY());
  // Garde l'ancienne coordonne
  Rect=TRect(0,0,W->Where.L()-1,W->Where.H()-1)+W->Corner;
  // Change la taille et la position de la fentre
  dX=Event.Where.X()-mWhere.X();
  dY=Event.Where.Y()-mWhere.Y();
  if ((dX)||(dY))
  { dX1=0; dX2=0; dY1=0; dY2=0;
    switch(CornerNo)
    { case 1 : dX1=dX; dY1=dY; break;
      case 2 : dX2=dX; dY1=dY; break;
      case 3 : dX2=dX; dY2=dY; break;
      case 4 : dX1=dX; dY2=dY; break;
    }
    dX=-dX1+dX2;
    dY=-dY1+dY2;
    // Demande de retrac l'ancienne position/taille
    W->Invalidate();
    // Change la position/taille
    W->Where.P1()+=TPoint(dX1,dY1);
    W->Where.P2()+=TPoint(dX1,dY1);
    W->DoChangeSize(dX,dY);
    // Met  jour le systme de recouvrement
    Desktop->UpdateClipZone();
    // Demande le retrac de la nouvelle position/taille
    W->Invalidate();
  }
}

// ----- TWindowBack

// Constructors

TWindowBack::TWindowBack() : TZone()
{ Init();
}

TWindowBack::TWindowBack(int X, int Y, int L, int H) :
  TZone(X,Y,L,H)
{ Init();
}

TWindowBack::TWindowBack(TRect& R) : TZone(R)
{ Init();
}

void TWindowBack::Init(void)
{ Register=RegTWindowBack;
  Ident=IdentTWindowBack;
  SetOptions(opCSHiX | opCSHiY);
}

// Graphics

void TWindowBack::Draw(TRect& )
{ SetSysColor(GetColor(LightGray));
  Bar(0,0,Where.L()-1,Where.H()-1);
}
