#include "Common/Common.H"
#include "Mecanism/Disk.H"
#include "Mecanism/SetUp.H"
#include "Saisie.H"
#include <conio.h>

#define WorkColor   0x1B
#define HeaderColor 0x07

// ----- Fonctions

char TmpStr[100];
int  Language,Rep;

void Screen(void)
{ textattr(HeaderColor);
  clrscr();
  gotoxy(26,1);cprintf("");
  gotoxy(26,2);cprintf(" S     W    O    R     D ");
  gotoxy(26,3);cprintf(" System  of Windows for  the ");
  gotoxy(26,4);cprintf(" ORganisation of the Desktop ");
  gotoxy(26,5);cprintf("");
  gotoxy(1,25);cprintf("V2.00");
  gotoxy(44,25);cprintf("Copyright (C) 1993,1995 Eric NICOLAS");
  textattr(WorkColor);
  gotoxy(1,24);cprintf("");
  gotoxy(1,7); cprintf(" SETUP Program ");
  window(1,8,80,23);
  clrscr();
}

int Present(void)
{ textattr(WorkColor); clrscr();
  gotoxy(1,1);
  cputs("\r\n"
        "  This program is used in order to setup SWORD's configuration.\r\n"
        "  You will be able to specify those parameters : \r\n"
        "       Screen resolution\r\n"
        "      . Screen colors\r\n"
        "\r\n\r\n"
        "  Press any key to continue...");
  GetChar();
  return 0;
}

int AskGraphReso(void)
{ textattr(WorkColor); clrscr();
  gotoxy(2,2);cprintf("The actual graphical resolution is : %dx%d",SetUp.ScreenX,SetUp.ScreenY);
  gotoxy(2,3);cprintf("Choose the new graphical resolution...");
  gotoxy(5,5);cprintf("0. Abort   ");
  gotoxy(5,7);cprintf("1. 640x480  (with all drivers)");
  gotoxy(5,8);cprintf("2. 800x600  (with SVGA driver)");
  gotoxy(5,9);cprintf("3. 1024x768 (with SVGA driver and a big screen (>14'))");
  gotoxy(5,11);cprintf("Your choice : ");
  Rep=AskDigit(3);
  switch(Rep)
  { case 0 :
      return 1;
    case 1 :
      SetUp.ScreenX=640;   SetUp.ScreenY=480;
      break;
    case 2 :
      SetUp.ScreenX=800;   SetUp.ScreenY=600;
      break;
    case 3 :
      SetUp.ScreenX=1024;  SetUp.ScreenY=768;
      break;
  }
  return 0;
}

int AskGraphColors(void)
{ textattr(WorkColor); clrscr();
  gotoxy(2,2);cprintf("The actual graphical colors is : %d colors",SetUp.ScreenColors);
  gotoxy(2,3);cprintf("Choose the new graphical colors...");
  gotoxy(5,5);cprintf("0. Abort   ");
  gotoxy(5,7);cprintf("1. 16       (with all drivers)");
  gotoxy(5,8);cprintf("2. 256      (with SVGA driver)");
  gotoxy(5,9);cprintf("3. 32000    (with SVGA driver)");
  gotoxy(5,11);cprintf("Your choice : ");
  Rep=AskDigit(3);
  switch(Rep)
  { case 0 :
      return 1;
    case 1 :
      SetUp.ScreenColors=16;
      break;
    case 2 :
      SetUp.ScreenColors=256;
      break;
    case 3 :
      SetUp.ScreenColors=32000;
      break;
  }
  return 0;
}


int Confirme(void)
{ textattr(WorkColor); clrscr();
  gotoxy(2,2); cprintf("You choose the following parameters...");
  gotoxy(5,4); cprintf("Graphical resolution       : %dx%d",SetUp.ScreenX,SetUp.ScreenY);
  gotoxy(5,5); cprintf("Graphical colors           : %d",SetUp.ScreenColors);
  gotoxy(2,6); cprintf("Please confirm before saving...");
  gotoxy(5,8); cprintf("0. Abort");
  gotoxy(5,9); cprintf("1. Exit and save new parameters");
  gotoxy(5,11);cprintf("Your choice : ");
  Rep=AskDigit(1);
  switch(Rep)
  { case 0 : return 1;
    case 1 : return 0;
  }
  return 0;
}

void Quit(int Abort)
{ textattr(0x07);
  window(1,1,80,25);
  clrscr();
  if (Abort) printf("SWORD SETUP Program Aborted.\n\n");
        else printf("SWORD SETUP Termined normally.\n\n");
  exit(0);
}

// ----- Programme principal

int main(char , char *argv[])
{ // Initialise le systme
  InitCommon(argv[0]);
  InitSetUp();
  // Prpare l'cran
  Screen();
  // Prsentations des fonctionnalits du programme de SetUp
  Present();
  // Demande la rsolution graphique d'excution
  if (AskGraphReso()) Quit(1);
  // Demande les couleurs des graphiques d'excution
  if (AskGraphColors()) Quit(1);
  // Affiche les paramtres et demande confirmation avant criture
  if (Confirme()) Quit(1);
  // Ecrit le Setup ainsi choisi
  WriteSetUp();
  DoneCommon();
  Quit(0);
  return 0;
}