/* Project SWORD
   V2.0

   SubSystem : Mathematical toolbox
   File      : Include/ToolBox/Math/Vector.H
   Author    : Eric NICOLAS
   Overview  : Variable size vectors arithmetics
   UpDate    : May 18, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _TOOLBOX_MATH_VECTOR_H_
#define _TOOLBOX_MATH_VECTOR_H_

extern int VectorDefaultSize;

struct TVector
{ // Datas
  int      Size;
  complex *Tabl;
  // Constructors / Destructor
  TVector(int eSize=VectorDefaultSize);
  TVector(TVector& V);
  virtual ~TVector();
          void Reset(void);
  // Using vectors
  TVector  operator=(TVector& V);
  complex& operator()(int N);
  // Operations on vectors
  // -,+,*,/ : Element to Element
  TVector  operator+(TVector& V);
  TVector  operator+=(TVector& V);
  TVector  operator-(TVector& V);
  TVector  operator-=(TVector& V);
  TVector  operator*(TVector& V);
  TVector  operator*=(TVector& V);
  TVector  operator/(TVector& V);
  TVector  operator/=(TVector& V);
  // Operations between vectors and complexes
  friend   TVector  operator*(TVector& V, complex  C);
  friend   TVector  operator*(complex  C, TVector& V);
	       TVector  operator*=(complex C);
  friend   TVector  operator/(TVector& V, complex  C);
  friend   TVector  operator/(complex  C, TVector& V);
	       TVector  operator/=(complex C);
  // %,^ : Scalar and Vectorial product
  complex  operator%(TVector& V);
  TVector  operator^(TVector& V);
  // Functions on vectors
  friend float norm(TVector& V);    // = V%V
  friend float abs(TVector& V);     // = sqrt(V%V)
};

// Inline functions

inline complex &TVector::operator()(int N)
{ if (N<0)     { LastError=MError_Vector_OutOfSize; N=0;      }
  if (N>=Size) { LastError=MError_Vector_OutOfSize; N=Size-1; }
  return Tabl[N];
}

#endif // _TOOLBOX_MATH_VECTOR_H_
