/* Project SWORD
   V2.0

   SubSystem : Interface with IntList INTERRUP.LST file
   ErrNos    : 3000..3099
   File      : Include/ToolBox/IntList/Index.H
   Author    : Eric NICOLAS
   Overview  : Using the IntList Index INTERRUP.IDX
   UpDate    : Nov 13, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _TOOLBOX_INTLIST_INDEX_H_
#define _TOOLBOX_INTLIST_INDEX_H_

#define erIntListFilesMissing   3000
#define erIntListWrongEntryNo   3001

struct TIntListIDX
{ long Position       PACKED;           // Position in the file
  byte IntNo          PACKED;           // Int no
  char FstNumber[5]   PACKED;           // AH or AX
  char SecNumber[5]   PACKED;           // Other : BH,BX,CH,CX...
  char SecReg[3]      PACKED;           // Other register name
  char Category       PACKED;           // Category : A,a,B,b...
  char Special[6]     PACKED;           // Special : UuPRCO after INT NO
  char Title[80]      PACKED;
};

extern long IDXEntriesNumber;

void BuildIntListIDXDescription(TIntListIDX *Entry, char *Str);
void GetIntListIDX(TIntListIDX *Entry, int N);

void InitIDX(void);
void DoneIDX(void);

#endif // TOOLBOX_INTLIST_INDEX_H_
