/* Project SWORD
   V2.0

   SubSystem : ToolBox for 3D graphics
   File      : Include/ToolBox/Graph3D/Transf.H
   Author    : Eric NICOLAS
   Overview  : Object TTransform : A geometrical transformation matrix
   UpDate    : Mar 18, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _TOOLBOX_GRAPH3D_TRANSF_H_
#define _TOOLBOX_GRAPH3D_TRANSF_H_

struct TTransform
{ protected:
    float Coefs[4][4];
  public:
    // Constructors
    TTransform();
    TTransform(TTransform& T);
    // Acces to datas
            float     &operator()(int i, int j);
    // Operations on Transormation matrix
            TTransform operator*(TTransform& T);
            float      Det22(int i1, int i2, int j1, int j2);
            float      Det33(int i1, int i2, int i3, int j1, int j2, int j3);
    friend  TTransform Inv(TTransform& T);
            float      Det();
    // Using Transformation matrix on points
            TPoint3D operator*(TPoint3D& P);
};

// Generation of Geometrical transformations

TTransform Homothetie(TPoint3D& Coef);
TTransform Translation(TPoint3D& V);
TTransform RotateOXY(float A);
TTransform RotateOYZ(float A);
TTransform RotateOXZ(float A);

// inline functions

inline float &TTransform::operator()(int j, int i)
{ return Coefs[j][i];
}

#endif // _TOOLBOX_GRAPH3D_TRANSF_H_
