/** 
 ** SCALE.H 
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#ifndef _SCALE_H_
#define _SCALE_H_

#ifdef __TURBOC__
# pragma inline
# define SCALE(var,arg,nom,den) do {					\
    _AX = (den);							\
    asm push	ax;							\
    _AX = (nom);							\
    asm push	ax;							\
    _AX = (arg);							\
    asm pop	bx;							\
    asm imul	bx;							\
    asm pop	bx;							\
    asm idiv	bx;							\
    (var) = _AX;							\
} while(0)
# define USCALE(var,arg,nom,den) do {					\
    _AX = (den);							\
    asm push	ax;							\
    _AX = (nom);							\
    asm push	ax;							\
    _AX = (arg);							\
    asm pop	bx;							\
    asm mul	bx;							\
    asm pop	bx;							\
    asm div	bx;							\
    (var) = _AX;							\
} while(0)
#endif

#ifdef __GNUC__
# define SCALE(var,arg,num,den)						\
    ((var) = ((arg) * (num)) / (den))
# define USCALE(var,arg,num,den)					\
    ((var) = ((unsigned)(arg) * (unsigned)(num)) / (unsigned)(den))
#endif

#endif /* whole file */

