/**
 ** PIFILLP.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "p8514a.h"

static int bg_mixtable[] = {
    BSS_BKGDCOL | MIX_SRC,	      /* C_SET */
    BSS_BKGDCOL | MIX_XOR,	      /* C_XOR */
    BSS_BKGDCOL | MIX_OR,	      /* C_OR  */
    BSS_BKGDCOL | MIX_AND	      /* C_AND */
};

void _GrPSFillPattern(int x,int y,int width,GrPattern *p)
{
	if(width <= 0) return;
	if(p->gp_ispixmap) {
	    int patw = p->gp_pxp_width;
	    int xpos = (x + CURC->gc_xoffset) % patw;
	    int ypos = (y + CURC->gc_yoffset) % p->gp_pxp_height;
	    while(width > 0) {
		int curw = MIN(width,(patw - xpos));
		_GrPSPixCopy(CURC,PIX_ADDR(CURC,x,y),
		    (GC *)(&p->gp_pxp_source),PIX_ADDR(&p->gp_pxp_source,xpos,ypos),
		    curw,1,p->gp_pxp_oper
		);
		width -= curw;
		x += curw;
		xpos = 0;
	    }
	    return;
	}
	if(CURC->gc_onscreen) {
	    int fgc,bgc,bits,fgop,bgop,words;
	    x += CURC->gc_xoffset;
	    y += CURC->gc_yoffset;
	    bits = p->gp_bmp_data[y % p->gp_bmp_height];
	    fgc  = p->gp_bmp_fgcolor;
	    bgc  = p->gp_bmp_bgcolor;
	    fgop = C_OPER(fgc);
	    bgop = C_OPER(bgc);
	    WaitQueue(6);
	    outpw(FRGD_COLOR,fgc);
	    outpw(BKGD_COLOR,bgc);
	    outpw(FRGD_MIX,_GrPIMixTable[fgop]);
	    outpw(BKGD_MIX,bg_mixtable[bgop]);
	    outpw(CUR_X,x);
	    outpw(CUR_Y,y);
	    WaitQueue(3);
	    outpw(MAJ_AXIS_PCNT,(width - 1));
	    outpw(MULTIFUNC_CNTL,(PIX_CNTL | MIXSEL_EXPPC));
	    outpw(CMD,(CMD_LINE | LINETYPE | VECDIR_000 | PCDATA | _16BIT | BYTSEQ | DRAW | PLANAR | WRTDATA));
	    words = (width + 15) >> 4;
	    bits = ((bits & 0xff) >> (8 - (x & 7))) | ((bits << (x & 7)) & 0xff);
	    bits |= (bits << 8);
	    while(--words >= 0) outpw(PIX_TRANS,bits);
	    outpw(MULTIFUNC_CNTL,(PIX_CNTL | 0));
	    return;
	}
	_GrP8FillPattern(x,y,width,p);
}

