/**
 ** P8INIT.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "p8.h"
#include "grdriver.h"

/*
 * An element of this table gets XOR-ed with the significant bits of
 * the color. It has to be drawn only if the result is nonzero
 */
int _GrP8DrawTable[4] = {
    ~C_SIGNIF,		/* C_SET -- always draw */
    0,			/* C_XOR -- draw only if non-zero */
    0,			/* C_OR  -- draw only if non-zero */
    C_SIGNIF		/* C_AND -- draw only if not all 1-s */
};

int _GrP8LmaskTable[] = { 0, 0x0e, 0x0c, 0x08 };
int _GrP8RmaskTable[] = { 0, 0x01, 0x03, 0x07 };

int  _GrP8Chain4Off;
int  _GrP8Chain4On;

char _GrP8PlanarModeOn;
char _GrP8UsePlanarMode;

void _GrP8Init(int accesstype)
{
	_GrP8UsePlanarMode = FALSE;
	if(accesstype == GRD_8_F_PLANES) {
	    __READ_VGA_REG__(VGA_SEQUENCER_PORT,4,_GrP8Chain4On);
	    _GrP8Chain4Off     = _GrP8Chain4On & ~8;
	    _GrP8Chain4Off     = (_GrP8Chain4Off << 8) | 4;
	    _GrP8Chain4On      = (_GrP8Chain4On  << 8) | 4;
	    _GrP8PlanarModeOn  = FALSE;
	    _GrP8UsePlanarMode = TRUE;
	}
}

