/** 
 ** P4INIT.C 
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "p4.h"
#include "gmalloc.h"
#include "grdriver.h"

int _GrP4ModeReg;			/* saved bits of mode register */

/*
 * VGA write operations table -- map our color flags to the EGA/VGA
 * function selection register values
 */
int _GrP4WriteOps[] = {
    (VGA_FUNC_SET << 8) + VGA_ROT_FN_SEL_REG,	   /* C_SET */
    (VGA_FUNC_XOR << 8) + VGA_ROT_FN_SEL_REG,	   /* C_XOR */
    (VGA_FUNC_OR  << 8) + VGA_ROT_FN_SEL_REG,	   /* C_OR  */
    (VGA_FUNC_AND << 8) + VGA_ROT_FN_SEL_REG	   /* C_AND */
};

/*
 * An element of this table gets XOR-ed with the significant bits of
 * the color. It has to be drawn only if the result is nonzero
 */
int _GrP4DrawTable[4] = {
    ~C_SIGNIF,		/* C_SET -- always draw */
    0,			/* C_XOR -- draw only if non-zero */
    0,			/* C_OR  -- draw only if non-zero */
    C_SIGNIF		/* C_AND -- draw only if not all 1-s */
};


void _GrP4Init(int memsize)
{
	char far *start;
	long total,used;

	_GetVGAModeMask();
	_SetVGAWriteMode(0);
	_SetVGAWriteAllPlanes();
	_SetVGASetResetPlanes(0x0f);
	used = ((long)_GrScreenX * (long)_GrScreenY) / 8L;
	switch(memsize) {
	    case GRD_64K:   total = 0x10000L  / 8L; break;
	    case GRD_128K:  total = 0x20000L  / 8L; break;
	    case GRD_256K:  total = 0x40000L  / 8L; break;
	    case GRD_512K:  total = 0x80000L  / 8L; break;
	    case GRD_1024K: total = 0x100000L / 8L; break;
	    default:	    for(total = 1L; total < used; total <<= 1);
	}
#ifdef _MAXVIDPLANESIZE
	if(total > _MAXVIDPLANESIZE) total = _MAXVIDPLANESIZE;
#endif
	if(!_GrBigFrameBuffer && (total >= 0x10000L)) total = 0x10000L;
	if((total -= used) < 0L) total = 0L;
	start = (char far *)((char huge *)_GrVidPage.gc_baseaddr + used);
	_GrVidMemInit(start,(unsigned int)total);
}

