/**
 ** LAYOUT.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"

int GrLineOffset(int width)
{
	if(width > 0) switch(_GrNumColors) {
#if (GRXPLANES & 16)
	  case 32768:
	    return(width << 1);
#endif
	  case 256:
	    if(_GrDriverIndex == MODE_X_DRIVER)
		return((width + 3) >> 2);
	    return(width);
	  case 16:
	  case 2:
	    return((width + 7) >> 3);
	}
	return(0);
}

int GrNumPlanes(void)
{
	switch(_GrNumColors) {
	  case 16:
	    return(4);
	  case 256:
	    if(_GrDriverIndex == MODE_X_DRIVER) return(4);
	  default:
	    return(1);
	}
}

long GrPlaneSize(int w,int h)
{
	return((h > 0) ? ((long)GrLineOffset(w) * (long)h) : 0L);
}

long GrContextSize(int w,int h)
{
	return(GrPlaneSize(w,h) * (long)GrNumPlanes());
}

