/**
 ** BIOSFONT.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"
#include "grxfont.h"
#include "grxfile.h"
#include "interrup.h"

#include <string.h>

static FixedFont bios8x8font  = { { 0 }, 0 };
static FixedFont bios8x14font = { { 0 }, 0 };
static FixedFont bios8x16font = { { 0 }, 0 };

GrFont *GrLoadBIOSFont(char *name)
{
	FixedFont *result;
	REGISTERS reg;
	int height,baseline;

	switch(_GrAdapterType) {
	  case GR_VGA:
	  case GR_8514A:
	  case GR_S3:
	    if(strcmp(name,"@:pc8x16"FNTEXT) == 0) {
		result	 = &bios8x16font;
		height	 = 16;
		baseline = 11;
		reg.r_bx = 0x0600;
		break;
	    }
	  case GR_EGA:
	    if(strcmp(name,"@:pc8x14"FNTEXT) == 0) {
		result	 = &bios8x14font;
		height	 = 14;
		baseline = 10;
		reg.r_bx = 0x0200;
		break;
	    }
	    if(strcmp(name,"@:pc8x8"FNTEXT) == 0) {
		result	 = &bios8x8font;
		height	 = 8;
		baseline = 6;
		reg.r_bx = 0x0300;
		break;
	    }
	  default:
	    return(NULL);
	}
	if(result->ff_bits == (char far *)NULL) {
	    reg.r_ax = 0x1130;
	    int10(&reg);
	    result->h.fnt_isfixed  = TRUE;
	    result->h.fnt_width	   = 8;
	    result->h.fnt_height   = height;
	    result->h.fnt_minchar  = 0;
	    result->h.fnt_maxchar  = 255;
	    result->h.fnt_internal = TRUE;
	    result->h.fnt_baseline = baseline;
	    result->h.fnt_undwidth = 1;
	    strcpy(result->h.fnt_name,name);
	    strcpy(result->h.fnt_family,"pc");
	    result->ff_chrsize = height;
#ifdef __GNUC__
	    result->ff_bits = (char *)reg.r_bp;
#endif
#ifdef __TURBOC__
	    result->ff_bits = MK_FP(reg.r_es,reg.r_bp);
#endif
	}
	return((GrFont *)result);
}

