$!
$! This file sets things up to build gas on a VMS system to generate object
$! files for a VMS system.  We do not use the configure script, since we
$! do not have /bin/sh to execute it.
$!
$! If you are running this file, then obviously the host is vax-dec-vms.
$! [That's no longer obvious, but there's not much we can do about alpha yet.]
$!
$gas_host="vms"
$!
$cpu_type="vax"
$emulation="generic"
$obj_format="vms"
$atof="vax"
$!
$	DELETE	= "delete/noConfirm"
$	ECHO	= "write sys$output"
$!
$! Target specific information
$call link targ-cpu.c	[.config]tc-'cpu_type'.c
$call link targ-cpu.h	[.config]tc-'cpu_type'.h
$call link targ-env.h	[.config]te-'emulation'.h
$!
$! Code to handle the object file format.
$call link obj-format.h	[.config]obj-'obj_format'.h
$call link obj-format.c	[.config]obj-'obj_format'.c
$!
$! Code to handle floating point.
$call link atof-targ.c	[.config]atof-'atof'.c
$!
$!
$! Create the file version.opt, which helps identify the executable.
$!
$if f$trnlnm("IFILE$").nes."" then  close/noLog ifile$
$search Makefile.in "VERSION="/Exact/Output=config-gas-tmp.tmp
$open ifile$ config-gas-tmp.tmp
$read ifile$ line
$close ifile$
$DELETE config-gas-tmp.tmp;*
$! Discard "VERSION=" and "\n" parts.
$ijk=f$locate("=",line)+1
$line=f$extract(ijk,f$length(line)-ijk,line)
$! [what "\n" part??  this seems to be useless, but is benign]
$ijk=f$locate("\n",line)
$line=f$extract(0,ijk,line)
$!
$ if f$search("version.opt").nes."" then DELETE version.opt;*
$copy _NL: version.opt
$open/Append ifile$ version.opt
$write ifile$ "identification="+""""+line+""""
$close ifile$
$! Now write config.h.
$ if f$search("config.h").nes."" then DELETE config.h;*
$copy _NL: config.h
$open/Append ifile$ config.h
$write ifile$ "/* config.h.  Generated by config-gas.com. */
$write ifile$ "#ifndef GAS_VERSION"
$write ifile$ "#define GAS_VERSION      """,line,""""
$write ifile$ "#endif"
$write ifile$ "/*--*/"
$append [.config]vms-conf.h ifile$:
$close ifile$
$ECHO "Created config.h."
$!
$ if f$search("config.status") .nes. "" then DELETE config.status;*
$ copy _NL: config.status
$ open/Append file config.status
$ write file "Links are now set up for use with a vax running VMS."
$ close file
$ type config.status
$exit
$!
$!
$link:
$subroutine
$  if f$search(p1).nes."" then DELETE 'p1';*
$  copy 'p2' 'p1'
$  ECHO "Copied ''f$edit(p2,"LOWERCASE")' to ''f$edit(p1,"LOWERCASE")'."
$endsubroutine
