/* bioskey.c written pjbk as replacement for TURBOC version */
#include <dos.h>

int bioskey(int cmd)
{
  union REGS regs;
  regs.h.ah = cmd;
  int86( 0x16, &regs, &regs);
  switch ( cmd )
  {
  case 0x00:
  case 0x10:
    return regs.x.ax & 0xffff;
  case 0x01:
  case 0x11:
    if ((regs.x.flags & 0x40 ) == 0x40 )
      return 0;
    else
      return regs.x.ax & 0xffff;
  case 0x02:
  case 0x12:
    return regs.h.al;
  }
  return 0;
}
