/* This is file ACCESS.C */
/*
** Copyright (C) 1994 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <fcntl.h>
#include <sys/stat.h>
#include <unistd.h>
#include <go32.h>
#include <dpmi.h>

int access(const char *fn, int flags)
{
  _go32_dpmi_registers r;
  r.x.ss = r.x.sp = 0;
  r.h.ah = 0x43;
  r.h.al = 0;
  r.x.dx = _go32_info_block.linear_address_of_transfer_buffer & 0xf;
  r.x.ds = _go32_info_block.linear_address_of_transfer_buffer >> 4;

  dosmemput(fn, strlen(fn)+1, _go32_info_block.linear_address_of_transfer_buffer);

  asm("pushl %%ebx;pushl %%edi;movl %0,%%edi;movw $0x0300,%%ax;"
      "movw $0x0021,%%bx;movw $0,%%cx;int $0x31;popl %%edi;popl %%ebx"
      : : "r" (&r) : "eax" "ecx");

  if (r.x.flags & 1)		/* carry - file error */
    return -1;

  if (r.x.cx & 0x10)		/* directory? */
    return 0;			/* directories always OK */

  if ((flags & W_OK) && (r.x.cx & 1))
      return -1;		/* not writable */

  if (flags & X_OK)		/* use stat() for expensive X_OK check */
  {
    struct stat s;
    stat(fn, &s);
    if (!(s.st_mode & 0100))
      return -1;
  }

  return 0;			/* everything else is OK */
}
