
/* BBDEV.H - Copyright (c) 1992, Boca Research, Inc. */

/* State bit control for hardware handshake. */

#define BB_IO(x) (bb_devs[UNMODEM(x)].io) /* get io from dev#.*/
#define BB_CLR(x) (bb_devs[x].st &= 0x0FFF)        /* clear control bits.*/

#define BB_FLOW(x) (bb_devs[x].st & 0xC000)    /* true if DSR/CTS is low. */
#define BB_CTS_STOP(x) 	(bb_devs[x].st |= 0x8000) /* turn on CTS low bit. */
#define BB_CTS_START(x) (bb_devs[x].st &= 0x7FFF) /* turn off CTS low bit.*/
#define BB_DSR_STOP(x) 	(bb_devs[x].st |= 0x4000) /* turn on DSR low bit. */
#define BB_DSR_START(x) (bb_devs[x].st &= 0xBFFF) /* turn off DSR low bit.*/

#define BB_MDMSET(x) (bb_devs[(x)].st |= 0x2000) /* Mdm bit set. */
#define BB_MDMCLR(x) (bb_devs[(x)].st &= 0xDFFF) /* Mdm bit off. */
#define BB_ISMDM(x)  (bb_devs[(x)].st & 0x2000)  /* true if Mdm bit set. */

#define BB_LOOPSET(x) (bb_devs[(x)].st |= 0x1000) /* Loopback bit set. */
#define BB_LOOPCLR(x) (bb_devs[(x)].st &= 0xEFFF) /* Loopback bit off. */
#define BB_ISLOOP(x)  (bb_devs[(x)].st & 0x1000)  /* true if Loopback set.*/

#define BB_BADSET(x) (bb_devs[(x)].st |= 0x0800) /* BAD port bit set. */
#define BB_BADCLR(x) (bb_devs[(x)].st &= 0xF7FF) /* BAD port bit off. */
#define BB_ISBAD(x)  (bb_devs[(x)].st & 0x0800)  /* true if port is bad.*/

#define BB_RJ11 0x8000
#define BB_MAXBRDS 4
#define BB_MAXPORT 16
#define BB_PRTSZ 8   /* Size of the UART, offset of the next UART. */

/* Registers in the UART. */

#define TXD 0x00 	/* Transmit reg. */
#define RXD 0x00
#define DIVLSB 0x00
#define DIVMSB 0x01
#define INTENB 0x01
#define IER 0x01
#define IIR 0x02
#define FCR 0x02	/* 16550 FIFO control. */
#define LCR 0x03
#define MCR 0x04
#define LSR 0x05
#define MSR 0x06

/* Bits 0 - 2 of the IIR. */

#define MODEM_INTR 0x00
#define TX_INTR 0x02
#define RX_DATA_INTR 0x04
#define RX_STAT_INTR 0x06

/* Bits 0 - 3 of the INTENB. */

#define IERRXR 0x01
#define IERTXR 0x02
#define IERRXI 0x04
#define IERMSI 0x08

/* Values for the LCR. */

#define LCRCS5 0x00
#define LCRCS6 0x01
#define LCRCS7 0x02
#define LCRCS8 0x03
#define LCRSB1 0x00
#define LCRSB2 0x04
#define LCRPEN 0x08
#define LCRPEV 0x10
#define LCRSPE 0x20
#define LCRBRK 0x40
#define LCRDLAB 0x80

/* Bits 0 - 3 of the MCR. MCROUT2 is the interrupt enable bit. */

#define MCRDTR 0x01
#define MCRRTS 0x02
#define MCROUT1 0x04
#define MCROUT2 0x08
#define MCRLOOP 0x10

/* LSR. */

#define LSRRDR 0x01
#define LSRDOE 0x02
#define LSRPER 0x04
#define LSRFER 0x08
#define LSRBSD 0x10
#define LSRTRD 0x20
#define LSRTI  0x40
#define LSRFIFO 0x80

/* MSR */
#define MSRDCTS 0x01
#define MSRDDSR 0x02
#define MSRDRNG 0x04
#define MSRDDCD 0x08
#define MSRCTS  0x10
#define MSRDSR  0x20
#define MSRRNG  0x40
#define MSRDCD  0x80

/* FIFO control. */

#define FCRENB 0x01
#define FCRRXF 0x02
#define FCRTXF 0x04
#define FCRDMA 0x08
#define FCRTRIG1 0x00
#define FCRTRIG4 0x40
#define FCRTRIG8 0x80
#define FCRTRIG14 0xC0


struct bbdev {
	ushort io;
	ushort st;
};

