/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.glass.utils.Disposer;
import com.sun.glass.utils.DisposerRecord;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;

public abstract class Robot {
    private static final Permission allPermission = new AllPermission();
    private long ptr;
    private final RobotDisposerRecord disposerRecord;

    protected abstract long _create();

    protected Robot() {
        if (System.getSecurityManager() != null) {
            AccessController.checkPermission(allPermission);
        }
        this.ptr = this._create();
        if (this.ptr == 0L) {
            throw new RuntimeException("could not create platform robot");
        }
        this.disposerRecord = new RobotDisposerRecord(this.ptr);
        Disposer.addRecord(this, this.disposerRecord);
    }

    protected abstract void _destroy(long var1);

    public void destroy() {
        this._destroy(this.ptr);
        this.ptr = 0L;
        this.disposerRecord.ptr = 0L;
    }

    protected abstract void _keyPress(long var1, int var3);

    public void keyPress(int n) {
        this._keyPress(this.ptr, n);
    }

    protected abstract void _keyRelease(long var1, int var3);

    public void keyRelease(int n) {
        this._keyRelease(this.ptr, n);
    }

    protected abstract void _mouseMove(long var1, int var3, int var4);

    public void mouseMove(int n, int n2) {
        this._mouseMove(this.ptr, n, n2);
    }

    protected abstract void _mousePress(long var1, int var3);

    public void mousePress(int n) {
        this._mousePress(this.ptr, n);
    }

    protected abstract void _mouseRelease(long var1, int var3);

    public void mouseRelease(int n) {
        this._mouseRelease(this.ptr, n);
    }

    protected abstract void _mouseWheel(long var1, int var3);

    public void mouseWheel(int n) {
        this._mouseWheel(this.ptr, n);
    }

    protected abstract int _getMouseX(long var1);

    public int getMouseX() {
        return this._getMouseX(this.ptr);
    }

    protected abstract int _getMouseY(long var1);

    public int getMouseY() {
        return this._getMouseY(this.ptr);
    }

    protected abstract int _getPixelColor(long var1, int var3, int var4);

    public int getPixelColor(int n, int n2) {
        return this._getPixelColor(this.ptr, n, n2);
    }

    protected abstract Pixels _getScreenCapture(long var1, int var3, int var4, int var5, int var6, boolean var7);

    public Pixels getScreenCapture(int n, int n2, int n3, int n4, boolean bl) {
        Application.checkEventThread();
        return this._getScreenCapture(this.ptr, n, n2, n3, n4, bl);
    }

    public Pixels getScreenCapture(int n, int n2, int n3, int n4) {
        return this.getScreenCapture(n, n2, n3, n4, false);
    }

    private static class RobotDisposerRecord
    implements DisposerRecord {
        public volatile long ptr;

        public RobotDisposerRecord(long l) {
            this.ptr = l;
        }

        public void dispose() {
            if (this.ptr != 0L) {
                // empty if block
            }
        }
    }
}

