/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client;

import com.sun.xml.internal.ws.api.handler.MessageHandler;
import com.sun.xml.internal.ws.handler.HandlerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.soap.SOAPHandler;

public class HandlerConfiguration {
    private final Set<String> roles;
    private final List<Handler> handlerChain;
    private final List<LogicalHandler> logicalHandlers;
    private final List<SOAPHandler> soapHandlers;
    private final List<MessageHandler> messageHandlers;
    private Set<QName> handlerKnownHeaders;

    public HandlerConfiguration(Set<String> set, List<Handler> list) {
        this.roles = set;
        this.handlerChain = list;
        this.logicalHandlers = new ArrayList<LogicalHandler>();
        this.soapHandlers = new ArrayList<SOAPHandler>();
        this.messageHandlers = new ArrayList<MessageHandler>();
        this.handlerKnownHeaders = new HashSet<QName>();
        for (Handler handler : list) {
            Set<QName> set2;
            if (handler instanceof LogicalHandler) {
                this.logicalHandlers.add((LogicalHandler)handler);
                continue;
            }
            if (handler instanceof SOAPHandler) {
                this.soapHandlers.add((SOAPHandler)handler);
                set2 = ((SOAPHandler)handler).getHeaders();
                if (set2 == null) continue;
                this.handlerKnownHeaders.addAll(set2);
                continue;
            }
            if (handler instanceof MessageHandler) {
                this.messageHandlers.add((MessageHandler)handler);
                set2 = ((MessageHandler)handler).getHeaders();
                if (set2 == null) continue;
                this.handlerKnownHeaders.addAll(set2);
                continue;
            }
            throw new HandlerException("handler.not.valid.type", handler.getClass());
        }
    }

    public HandlerConfiguration(Set<String> set, HandlerConfiguration handlerConfiguration) {
        this.roles = set;
        this.handlerChain = handlerConfiguration.handlerChain;
        this.logicalHandlers = handlerConfiguration.logicalHandlers;
        this.soapHandlers = handlerConfiguration.soapHandlers;
        this.messageHandlers = handlerConfiguration.messageHandlers;
        this.handlerKnownHeaders = handlerConfiguration.handlerKnownHeaders;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public List<Handler> getHandlerChain() {
        if (this.handlerChain == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Handler>(this.handlerChain);
    }

    public List<LogicalHandler> getLogicalHandlers() {
        return this.logicalHandlers;
    }

    public List<SOAPHandler> getSoapHandlers() {
        return this.soapHandlers;
    }

    public List<MessageHandler> getMessageHandlers() {
        return this.messageHandlers;
    }

    public Set<QName> getHandlerKnownHeaders() {
        return this.handlerKnownHeaders;
    }
}

