/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.addressing;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.stream.buffer.XMLStreamBuffer;
import com.sun.xml.internal.ws.addressing.WsaTubeHelper;
import com.sun.xml.internal.ws.addressing.WsaTubeHelperImpl;
import com.sun.xml.internal.ws.addressing.v200408.MemberSubmissionAddressingConstants;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.OutboundReferenceParameterHeader;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.developer.MemberSubmissionAddressingFeature;
import com.sun.xml.internal.ws.developer.MemberSubmissionEndpointReference;
import com.sun.xml.internal.ws.message.stream.OutboundStreamHeader;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

public enum AddressingVersion {
    W3C("http://www.w3.org/2005/08/addressing", "<EndpointReference xmlns=\"http://www.w3.org/2005/08/addressing\">\n    <Address>http://www.w3.org/2005/08/addressing/anonymous</Address>\n</EndpointReference>", "http://www.w3.org/2006/05/addressing/wsdl", "http://www.w3.org/2006/05/addressing/wsdl", "http://www.w3.org/2005/08/addressing/anonymous", "http://www.w3.org/2005/08/addressing/none", new EPR(W3CEndpointReference.class, "Address", "ServiceName", "EndpointName", "InterfaceName", new QName("http://www.w3.org/2005/08/addressing", "Metadata"), "ReferenceParameters", null)){

        @Override
        String getActionMismatchLocalName() {
            return "ActionMismatch";
        }

        @Override
        public boolean isReferenceParameter(String string) {
            return string.equals("ReferenceParameters");
        }

        @Override
        public WsaTubeHelper getWsaHelper(WSDLPort wSDLPort, SEIModel sEIModel, WSBinding wSBinding) {
            return new WsaTubeHelperImpl(wSDLPort, sEIModel, wSBinding);
        }

        @Override
        String getMapRequiredLocalName() {
            return "MessageAddressingHeaderRequired";
        }

        @Override
        public String getMapRequiredText() {
            return "A required header representing a Message Addressing Property is not present";
        }

        @Override
        String getInvalidAddressLocalName() {
            return "InvalidAddress";
        }

        @Override
        String getInvalidMapLocalName() {
            return "InvalidAddressingHeader";
        }

        @Override
        public String getInvalidMapText() {
            return "A header representing a Message Addressing Property is not valid and the message cannot be processed";
        }

        @Override
        String getInvalidCardinalityLocalName() {
            return "InvalidCardinality";
        }

        @Override
        Header createReferenceParameterHeader(XMLStreamBuffer xMLStreamBuffer, String string, String string2) {
            return new OutboundReferenceParameterHeader(xMLStreamBuffer, string, string2);
        }

        @Override
        String getIsReferenceParameterLocalName() {
            return "IsReferenceParameter";
        }

        @Override
        String getWsdlAnonymousLocalName() {
            return "Anonymous";
        }

        @Override
        public String getPrefix() {
            return "wsa";
        }

        @Override
        public String getWsdlPrefix() {
            return "wsaw";
        }

        @Override
        public Class<? extends WebServiceFeature> getFeatureClass() {
            return AddressingFeature.class;
        }
    }
    ,
    MEMBER("http://schemas.xmlsoap.org/ws/2004/08/addressing", "<EndpointReference xmlns=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">\n    <Address>http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous</Address>\n</EndpointReference>", "http://schemas.xmlsoap.org/ws/2004/08/addressing", "http://schemas.xmlsoap.org/ws/2004/08/addressing/policy", "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous", "", new EPR(MemberSubmissionEndpointReference.class, "Address", "ServiceName", "PortName", "PortType", MemberSubmissionAddressingConstants.MEX_METADATA, "ReferenceParameters", "ReferenceProperties")){

        @Override
        String getActionMismatchLocalName() {
            return "InvalidMessageInformationHeader";
        }

        @Override
        public boolean isReferenceParameter(String string) {
            return string.equals("ReferenceParameters") || string.equals("ReferenceProperties");
        }

        @Override
        public WsaTubeHelper getWsaHelper(WSDLPort wSDLPort, SEIModel sEIModel, WSBinding wSBinding) {
            return new com.sun.xml.internal.ws.addressing.v200408.WsaTubeHelperImpl(wSDLPort, sEIModel, wSBinding);
        }

        @Override
        String getMapRequiredLocalName() {
            return "MessageInformationHeaderRequired";
        }

        @Override
        public String getMapRequiredText() {
            return "A required message information header, To, MessageID, or Action, is not present.";
        }

        @Override
        String getInvalidAddressLocalName() {
            return this.getInvalidMapLocalName();
        }

        @Override
        String getInvalidMapLocalName() {
            return "InvalidMessageInformationHeader";
        }

        @Override
        public String getInvalidMapText() {
            return "A message information header is not valid and the message cannot be processed.";
        }

        @Override
        String getInvalidCardinalityLocalName() {
            return this.getInvalidMapLocalName();
        }

        @Override
        Header createReferenceParameterHeader(XMLStreamBuffer xMLStreamBuffer, String string, String string2) {
            return new OutboundStreamHeader(xMLStreamBuffer, string, string2);
        }

        @Override
        String getIsReferenceParameterLocalName() {
            return "";
        }

        @Override
        String getWsdlAnonymousLocalName() {
            return "";
        }

        @Override
        public String getPrefix() {
            return "wsa";
        }

        @Override
        public String getWsdlPrefix() {
            return "wsaw";
        }

        @Override
        public Class<? extends WebServiceFeature> getFeatureClass() {
            return MemberSubmissionAddressingFeature.class;
        }
    };

    public final String nsUri;
    public final String wsdlNsUri;
    public final EPR eprType;
    public final String policyNsUri;
    @NotNull
    public final String anonymousUri;
    @NotNull
    public final String noneUri;
    public final WSEndpointReference anonymousEpr;
    public final QName toTag;
    public final QName fromTag;
    public final QName replyToTag;
    public final QName faultToTag;
    public final QName actionTag;
    public final QName messageIDTag;
    public final QName relatesToTag;
    public final QName mapRequiredTag;
    public final QName actionMismatchTag;
    public final QName actionNotSupportedTag;
    public final String actionNotSupportedText;
    public final QName invalidMapTag;
    public final QName invalidCardinalityTag;
    public final QName invalidAddressTag;
    public final QName problemHeaderQNameTag;
    public final QName problemActionTag;
    public final QName faultDetailTag;
    public final QName fault_missingAddressInEpr;
    public final QName wsdlActionTag;
    public final QName wsdlExtensionTag;
    public final QName wsdlAnonymousTag;
    public final QName isReferenceParameterTag;
    private static final String EXTENDED_FAULT_NAMESPACE = "http://jax-ws.dev.java.net/addressing/fault";
    public static final String UNSET_OUTPUT_ACTION = "http://jax-ws.dev.java.net/addressing/output-action-not-set";
    public static final String UNSET_INPUT_ACTION = "http://jax-ws.dev.java.net/addressing/input-action-not-set";
    public static final QName fault_duplicateAddressInEpr;

    private AddressingVersion(String string2, String string3, String string4, String string5, String string6, String string7, EPR ePR) {
        this.nsUri = string2;
        this.wsdlNsUri = string4;
        this.policyNsUri = string5;
        this.anonymousUri = string6;
        this.noneUri = string7;
        this.toTag = new QName(string2, "To");
        this.fromTag = new QName(string2, "From");
        this.replyToTag = new QName(string2, "ReplyTo");
        this.faultToTag = new QName(string2, "FaultTo");
        this.actionTag = new QName(string2, "Action");
        this.messageIDTag = new QName(string2, "MessageID");
        this.relatesToTag = new QName(string2, "RelatesTo");
        this.mapRequiredTag = new QName(string2, this.getMapRequiredLocalName());
        this.actionMismatchTag = new QName(string2, this.getActionMismatchLocalName());
        this.actionNotSupportedTag = new QName(string2, "ActionNotSupported");
        this.actionNotSupportedText = "The \"%s\" cannot be processed at the receiver";
        this.invalidMapTag = new QName(string2, this.getInvalidMapLocalName());
        this.invalidAddressTag = new QName(string2, this.getInvalidAddressLocalName());
        this.invalidCardinalityTag = new QName(string2, this.getInvalidCardinalityLocalName());
        this.faultDetailTag = new QName(string2, "FaultDetail");
        this.problemHeaderQNameTag = new QName(string2, "ProblemHeaderQName");
        this.problemActionTag = new QName(string2, "ProblemAction");
        this.fault_missingAddressInEpr = new QName(string2, "MissingAddressInEPR", "wsa");
        this.isReferenceParameterTag = new QName(string2, this.getIsReferenceParameterLocalName());
        this.wsdlActionTag = new QName(string4, "Action");
        this.wsdlExtensionTag = new QName(string4, "UsingAddressing");
        this.wsdlAnonymousTag = new QName(string4, this.getWsdlAnonymousLocalName());
        try {
            this.anonymousEpr = new WSEndpointReference(new ByteArrayInputStream(string3.getBytes("UTF-8")), this);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new Error(xMLStreamException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error(unsupportedEncodingException);
        }
        this.eprType = ePR;
    }

    abstract String getActionMismatchLocalName();

    public static AddressingVersion fromNsUri(String string) {
        if (string.equals(AddressingVersion.W3C.nsUri)) {
            return W3C;
        }
        if (string.equals(AddressingVersion.MEMBER.nsUri)) {
            return MEMBER;
        }
        return null;
    }

    @Nullable
    public static AddressingVersion fromBinding(WSBinding wSBinding) {
        if (wSBinding.isFeatureEnabled(AddressingFeature.class)) {
            return W3C;
        }
        if (wSBinding.isFeatureEnabled(MemberSubmissionAddressingFeature.class)) {
            return MEMBER;
        }
        return null;
    }

    public static AddressingVersion fromPort(WSDLPort wSDLPort) {
        if (wSDLPort == null) {
            return null;
        }
        WebServiceFeature webServiceFeature = wSDLPort.getFeature(AddressingFeature.class);
        if (webServiceFeature == null) {
            webServiceFeature = wSDLPort.getFeature(MemberSubmissionAddressingFeature.class);
        }
        if (webServiceFeature == null) {
            return null;
        }
        return AddressingVersion.fromFeature(webServiceFeature);
    }

    public String getNsUri() {
        return this.nsUri;
    }

    public abstract boolean isReferenceParameter(String var1);

    public abstract WsaTubeHelper getWsaHelper(WSDLPort var1, SEIModel var2, WSBinding var3);

    public final String getNoneUri() {
        return this.noneUri;
    }

    public final String getAnonymousUri() {
        return this.anonymousUri;
    }

    public String getDefaultFaultAction() {
        return this.nsUri + "/fault";
    }

    abstract String getMapRequiredLocalName();

    public abstract String getMapRequiredText();

    abstract String getInvalidAddressLocalName();

    abstract String getInvalidMapLocalName();

    public abstract String getInvalidMapText();

    abstract String getInvalidCardinalityLocalName();

    abstract String getWsdlAnonymousLocalName();

    public abstract String getPrefix();

    public abstract String getWsdlPrefix();

    public abstract Class<? extends WebServiceFeature> getFeatureClass();

    abstract Header createReferenceParameterHeader(XMLStreamBuffer var1, String var2, String var3);

    abstract String getIsReferenceParameterLocalName();

    public static AddressingVersion fromFeature(WebServiceFeature webServiceFeature) {
        if (webServiceFeature.getID().equals("http://www.w3.org/2005/08/addressing/module")) {
            return W3C;
        }
        if (webServiceFeature.getID().equals("http://java.sun.com/xml/ns/jaxws/2004/08/addressing")) {
            return MEMBER;
        }
        return null;
    }

    @NotNull
    public static WebServiceFeature getFeature(String string, boolean bl, boolean bl2) {
        if (string.equals(AddressingVersion.W3C.policyNsUri)) {
            return new AddressingFeature(bl, bl2);
        }
        if (string.equals(AddressingVersion.MEMBER.policyNsUri)) {
            return new MemberSubmissionAddressingFeature(bl, bl2);
        }
        throw new WebServiceException("Unsupported namespace URI: " + string);
    }

    @NotNull
    public static AddressingVersion fromSpecClass(Class<? extends EndpointReference> clazz) {
        if (clazz == W3CEndpointReference.class) {
            return W3C;
        }
        if (clazz == MemberSubmissionEndpointReference.class) {
            return MEMBER;
        }
        throw new WebServiceException("Unsupported EPR type: " + clazz);
    }

    public static boolean isRequired(WebServiceFeature webServiceFeature) {
        if (webServiceFeature.getID().equals("http://www.w3.org/2005/08/addressing/module")) {
            return ((AddressingFeature)webServiceFeature).isRequired();
        }
        if (webServiceFeature.getID().equals("http://java.sun.com/xml/ns/jaxws/2004/08/addressing")) {
            return ((MemberSubmissionAddressingFeature)webServiceFeature).isRequired();
        }
        throw new WebServiceException("WebServiceFeature not an Addressing feature: " + webServiceFeature.getID());
    }

    public static boolean isRequired(WSBinding wSBinding) {
        AddressingFeature addressingFeature = wSBinding.getFeature(AddressingFeature.class);
        if (addressingFeature != null) {
            return addressingFeature.isRequired();
        }
        MemberSubmissionAddressingFeature memberSubmissionAddressingFeature = wSBinding.getFeature(MemberSubmissionAddressingFeature.class);
        if (memberSubmissionAddressingFeature != null) {
            return memberSubmissionAddressingFeature.isRequired();
        }
        return false;
    }

    public static boolean isEnabled(WSBinding wSBinding) {
        return wSBinding.isFeatureEnabled(MemberSubmissionAddressingFeature.class) || wSBinding.isFeatureEnabled(AddressingFeature.class);
    }

    static {
        fault_duplicateAddressInEpr = new QName(EXTENDED_FAULT_NAMESPACE, "DuplicateAddressInEpr");
    }

    public static final class EPR {
        public final Class<? extends EndpointReference> eprClass;
        public final String address;
        public final String serviceName;
        public final String portName;
        public final String portTypeName;
        public final String referenceParameters;
        public final QName wsdlMetadata;
        public final String referenceProperties;

        public EPR(Class<? extends EndpointReference> clazz, String string, String string2, String string3, String string4, QName qName, String string5, String string6) {
            this.eprClass = clazz;
            this.address = string;
            this.serviceName = string2;
            this.portName = string3;
            this.portTypeName = string4;
            this.referenceParameters = string5;
            this.referenceProperties = string6;
            this.wsdlMetadata = qName;
        }
    }
}

