/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.deploy;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.deploy.DeployAbstractTask;
import com.supermicro.ipmi.text.deploy.DeployBIOSAMITask;
import com.supermicro.ipmi.text.deploy.DeployBIOSATENTask;
import com.supermicro.ipmi.text.deploy.DeployBIOSPepperconTask;
import com.supermicro.ipmi.text.deploy.DeployTarget;

public class DeployTaskFactory {
    public static DeployAbstractTask createDeployTask(DeployTarget dTarget) {
        DeployAbstractTask deployTask = null;
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(dTarget.getConfig().getIp());
        if (IPMIMessagingCommand.isAMIGUID(guid) || IPMIMessagingCommand.isAMISIMBLGUID(guid)) {
            deployTask = new DeployBIOSAMITask(dTarget);
        } else if (IPMIMessagingCommand.isPepperconGUID(guid) || IPMIMessagingCommand.isSIMBL(guid)) {
            deployTask = new DeployBIOSPepperconTask(dTarget);
        } else if (IPMIMessagingCommand.isATENGUID(guid)) {
            deployTask = new DeployBIOSATENTask(dTarget);
        }
        dTarget.setDeployTask(deployTask);
        return deployTask;
    }
}

